/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.execution.dml.ArrayIndexer;
import io.crate.expression.operator.Operator;
import io.crate.expression.scalar.NumTermsPerDocQuery;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.SysColumns;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import io.crate.types.ObjectType;
import io.crate.types.StorageSupport;
import io.crate.types.TypeSignature;
import io.crate.types.UndefinedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.Uid;
import org.jetbrains.annotations.Nullable;

public final class EqOperator
extends Operator<Object> {
    public static final String NAME = "op_=";
    public static final Signature SIGNATURE = Signature.builder("op_=", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E"), TypeSignature.parse("E")).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build();
    private final DataType<Object> argType;

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, EqOperator::new);
    }

    private EqOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.argType = boundSignature.argTypes().get(0);
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 2) : "number of args must be 2";
        Object left = args[0].value();
        if (left == null) {
            return null;
        }
        Object right = args[1].value();
        if (right == null) {
            return null;
        }
        return this.argType.compare(left, right) == 0;
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        Reference ref;
        Symbol symbol;
        block9: {
            block8: {
                List<Symbol> args = function.arguments();
                symbol = args.get(0);
                if (!(symbol instanceof Reference)) break block8;
                ref = (Reference)symbol;
                symbol = args.get(1);
                if (symbol instanceof Literal) break block9;
            }
            return null;
        }
        Literal literal = (Literal)symbol;
        String fqn = ref.column().fqn();
        String storageIdentifier = ref.storageIdent();
        Object value = literal.value();
        if (value == null) {
            return new MatchNoDocsQuery("`" + fqn + "` = null is always null");
        }
        DataType<?> dataType = ref.valueType();
        return switch (dataType.id()) {
            case 12 -> EqOperator.refEqObject(function, ref.column(), (ObjectType)dataType, (Map)value, context);
            case 100 -> EqOperator.termsAndGenericFilter(function, storageIdentifier, dataType, (Collection)value, context, ref.hasDocValues(), ref.indexType());
            default -> EqOperator.fromPrimitive(dataType, storageIdentifier, value, ref.hasDocValues(), ref.indexType());
        };
    }

    @Nullable
    public static Query termsQuery(String column, DataType<?> type, Collection<?> values, boolean hasDocValues, IndexType indexType) {
        EqQuery<?> eqQuery;
        if (column.equals(SysColumns.ID.COLUMN.name())) {
            ArrayList<BytesRef> bytesRefs = new ArrayList<BytesRef>(values.size());
            for (Object value : values) {
                if (value == null) continue;
                bytesRefs.add(Uid.encodeId(value.toString()));
            }
            return bytesRefs.isEmpty() ? null : new TermInSetQuery(column, bytesRefs);
        }
        List<Object> nonNullValues = values.stream().filter(Objects::nonNull).toList();
        if (nonNullValues.isEmpty()) {
            return null;
        }
        StorageSupport<?> storageSupport = type.storageSupport();
        EqQuery<?> eqQuery2 = eqQuery = storageSupport == null ? null : storageSupport.eqQuery();
        if (eqQuery == null) {
            return EqOperator.booleanShould(column, type, nonNullValues, hasDocValues, indexType);
        }
        return eqQuery.termsQuery(column, nonNullValues, hasDocValues, indexType != IndexType.NONE);
    }

    @Nullable
    private static Query booleanShould(String column, DataType<?> type, Collection<?> values, boolean hasDocValues, IndexType indexType) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object term : values) {
            Query fromPrimitive = EqOperator.fromPrimitive(type, column, term, hasDocValues, indexType);
            if (fromPrimitive == null) {
                return null;
            }
            builder.add(fromPrimitive, BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)builder.build());
    }

    public static Function of(Symbol first, Symbol second) {
        return new Function(SIGNATURE, List.of(first, second), Operator.RETURN_TYPE);
    }

    private static Query termsAndGenericFilter(Function function, String column, DataType<?> arrayType, Collection<?> values, LuceneQueryBuilder.Context context, boolean hasDocValues, IndexType indexType) {
        return EqOperator.termsAndGenericFilter(function, column, arrayType, values, context, hasDocValues, indexType, BooleanClause.Occur.MUST);
    }

    public static Query termsAndGenericFilter(Function function, String column, DataType<?> arrayType, Collection<?> values, LuceneQueryBuilder.Context context, boolean hasDocValues, IndexType indexType, BooleanClause.Occur termQueryOccur) {
        boolean canUseArrayLengthIndex = context.tableInfo().versionCreated().onOrAfter(Version.V_5_9_0);
        BooleanQuery.Builder filterClauses = new BooleanQuery.Builder();
        Query genericFunctionFilter = LuceneQueryBuilder.genericFunctionFilter(function, context);
        if (values.isEmpty()) {
            if (canUseArrayLengthIndex) {
                Query arrayLengthTermQuery = ArrayIndexer.arrayLengthTermQuery(context.tableInfo().getReference(column), 0, context.tableInfo()::getReference);
                return termQueryOccur == BooleanClause.Occur.MUST_NOT ? Queries.not(arrayLengthTermQuery) : arrayLengthTermQuery;
            }
            if (!hasDocValues) {
                return genericFunctionFilter;
            }
            filterClauses.add((Query)NumTermsPerDocQuery.forColumn(column, arrayType, numDocs -> numDocs == 0), termQueryOccur);
            filterClauses.add(genericFunctionFilter, BooleanClause.Occur.MUST);
        } else {
            Query termsQuery = EqOperator.termsQuery(column, arrayType, Lists.flattenUnique(values), hasDocValues, indexType);
            if (termsQuery == null) {
                return genericFunctionFilter;
            }
            filterClauses.add(termsQuery, termQueryOccur);
            filterClauses.add(genericFunctionFilter, BooleanClause.Occur.MUST);
        }
        return filterClauses.build();
    }

    @Nullable
    public static Query fromPrimitive(DataType<?> type, String column, Object value, boolean hasDocValues, IndexType indexType) {
        EqQuery<?> eqQuery;
        if (column.equals(SysColumns.ID.COLUMN.name())) {
            return new TermQuery(new Term(column, Uid.encodeId((String)value)));
        }
        StorageSupport<?> storageSupport = type.storageSupport();
        EqQuery<?> eqQuery2 = eqQuery = storageSupport == null ? null : storageSupport.eqQuery();
        if (eqQuery == null) {
            return null;
        }
        return eqQuery.termQuery(column, value, hasDocValues, indexType != IndexType.NONE);
    }

    public static Query refEqObject(Function eq, ColumnIdent columnIdent, ObjectType type, Map<String, Object> value, LuceneQueryBuilder.Context context, BooleanClause.Occur termQueryOccur) {
        BooleanQuery.Builder boolBuilder = new BooleanQuery.Builder();
        int preFilters = 0;
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            Query innerQuery;
            String nestedStorageIdentifier;
            String key = entry.getKey();
            DataType<?> innerType = type.innerType(key);
            if (innerType == UndefinedType.INSTANCE) continue;
            ColumnIdent childColumn = columnIdent.getChild(key);
            Reference childRef = context.getRef(childColumn);
            String string = nestedStorageIdentifier = childRef != null ? childRef.storageIdent() : childColumn.fqn();
            if (DataTypes.isArray(innerType)) {
                innerQuery = EqOperator.termsAndGenericFilter(eq, nestedStorageIdentifier, innerType, (Collection)entry.getValue(), context, childRef.hasDocValues(), childRef.indexType(), termQueryOccur);
            } else {
                innerQuery = EqOperator.fromPrimitive(innerType, nestedStorageIdentifier, entry.getValue(), childRef.hasDocValues(), childRef.indexType());
                if (termQueryOccur == BooleanClause.Occur.MUST_NOT) {
                    innerQuery = Queries.not(innerQuery);
                }
            }
            if (innerQuery == null) continue;
            ++preFilters;
            boolBuilder.add(innerQuery, BooleanClause.Occur.MUST);
        }
        if (preFilters > 0 && preFilters == value.size()) {
            return boolBuilder.build();
        }
        Query genericEqFilter = LuceneQueryBuilder.genericFunctionFilter(eq, context);
        if (preFilters == 0) {
            return genericEqFilter;
        }
        boolBuilder.add(LuceneQueryBuilder.genericFunctionFilter(eq, context), BooleanClause.Occur.FILTER);
        return boolBuilder.build();
    }

    private static Query refEqObject(Function eq, ColumnIdent columnIdent, ObjectType type, Map<String, Object> value, LuceneQueryBuilder.Context context) {
        return EqOperator.refEqObject(eq, columnIdent, type, value, context, BooleanClause.Occur.MUST);
    }
}

