/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.TypeSignature;
import java.util.List;

public class ExistsOperator
extends Operator<List<Object>> {
    public static final String NAME = "_exists";

    public static void register(Functions.Builder builder) {
        Signature signature = Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)")).returnType(Operator.RETURN_TYPE.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build();
        builder.add(signature, ExistsOperator::new);
    }

    private ExistsOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<List<Object>> ... args) {
        List value = (List)args[0].value();
        if (value == null) {
            return null;
        }
        return !value.isEmpty();
    }
}

