/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.FourPredicate;
import io.crate.expression.operator.LikeOperators;
import io.crate.expression.operator.Operator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Roles;
import io.crate.types.EqQuery;
import io.crate.types.StorageSupport;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.Nullable;

public class LikeOperator
extends Operator<String> {
    private final FourPredicate<String, String, Character, LikeOperators.CaseSensitivity> matcher;
    private final LikeOperators.CaseSensitivity caseSensitivity;
    private final java.util.function.Function<Input<String>[], Character> escapeFromInputs;
    private final java.util.function.Function<List<Symbol>, Character> escapeFromSymbols;
    private final int evaluateArgsCount;

    public LikeOperator(Signature signature, BoundSignature boundSignature, FourPredicate<String, String, Character, LikeOperators.CaseSensitivity> matcher, LikeOperators.CaseSensitivity caseSensitivity) {
        super(signature, boundSignature);
        this.matcher = matcher;
        this.caseSensitivity = caseSensitivity;
        this.evaluateArgsCount = signature.getArgumentDataTypes().size();
        if (signature.getArgumentDataTypes().size() == 3) {
            this.escapeFromInputs = inputs -> LikeOperator.validateAndGetEscape(inputs[2]);
            this.escapeFromSymbols = symbols -> {
                Symbol escape = (Symbol)symbols.get(2);
                assert (escape instanceof Literal) : "Escape character must be a literal";
                return LikeOperator.validateAndGetEscape((Literal)escape);
            };
        } else {
            this.escapeFromInputs = ignored -> LikeOperators.DEFAULT_ESCAPE;
            this.escapeFromSymbols = ignored -> LikeOperators.DEFAULT_ESCAPE;
        }
    }

    @Nullable
    private static Character validateAndGetEscape(Input<?> escapeInput) {
        String value = (String)escapeInput.value();
        if (value.length() > 1) {
            throw new IllegalArgumentException("ESCAPE must be a single character");
        }
        if (value.isEmpty()) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    @Override
    public Scalar<Boolean, String> compile(List<Symbol> arguments, String userName, Roles roles) {
        Symbol pattern = arguments.get(1);
        if (pattern instanceof Input) {
            Object value = ((Input)pattern).value();
            if (value == null) {
                return this;
            }
            Character escapeChar = this.escapeFromSymbols.apply(arguments);
            return new CompiledLike(this.signature, this.boundSignature, (String)value, escapeChar, this.caseSensitivity);
        }
        return super.compile(arguments, userName, roles);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == this.evaluateArgsCount) : "number of args must be " + this.evaluateArgsCount;
        String expression = (String)args[0].value();
        String pattern = (String)args[1].value();
        if (expression == null || pattern == null) {
            return null;
        }
        Character escapeChar = this.escapeFromInputs.apply(args);
        return this.matcher.test(expression, pattern, escapeChar, this.caseSensitivity);
    }

    @Override
    @Nullable
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        List<Symbol> args = function.arguments();
        Symbol symbol = args.get(0);
        if (symbol instanceof Reference) {
            Reference ref = (Reference)symbol;
            symbol = args.get(1);
            if (symbol instanceof Literal) {
                Literal patternLiteral = (Literal)symbol;
                Object value = patternLiteral.value();
                assert (value instanceof String) : "LikeOperator is registered for string types. Value must be a string";
                if (((String)value).isEmpty()) {
                    EqQuery<?> eqQuery;
                    StorageSupport<?> storageSupport = ref.valueType().storageSupport();
                    EqQuery<?> eqQuery2 = eqQuery = storageSupport == null ? null : storageSupport.eqQuery();
                    if (eqQuery == null) {
                        return null;
                    }
                    return eqQuery.termQuery(ref.storageIdent(), value, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
                }
                Character escapeChar = this.escapeFromSymbols.apply(args);
                return this.caseSensitivity.likeQuery(ref.storageIdent(), (String)value, escapeChar, ref.indexType() != IndexType.NONE);
            }
        }
        return null;
    }

    private static class CompiledLike
    extends Scalar<Boolean, String> {
        private final Pattern pattern;

        CompiledLike(Signature signature, BoundSignature boundSignature, String pattern, Character escapeChar, LikeOperators.CaseSensitivity caseSensitivity) {
            super(signature, boundSignature);
            this.pattern = LikeOperators.makePattern(pattern, caseSensitivity, escapeChar);
        }

        @Override
        @SafeVarargs
        public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
            String value = (String)args[0].value();
            if (value == null) {
                return null;
            }
            return this.pattern.matcher(value).matches();
        }
    }
}

