/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.expression.operator.CmpOperator;
import io.crate.expression.operator.any.AnyOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.types.ArrayType;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public final class AnyRangeOperator
extends AnyOperator<Object> {
    private final Comparison comparison;

    AnyRangeOperator(Signature signature, BoundSignature boundSignature, Comparison comparison) {
        super(signature, boundSignature);
        this.comparison = comparison;
    }

    @Override
    boolean matches(Object probe, Object candidate) {
        return this.comparison.isMatch(this.leftType.compare(probe, candidate));
    }

    @Override
    protected Query refMatchesAnyArrayLiteral(Function any, Reference probe, Literal<?> candidates, LuceneQueryBuilder.Context context) {
        if (ArrayType.dimensions(candidates.valueType()) > 1) {
            return null;
        }
        List<Object> nonNullValues = StreamSupport.stream(((Iterable)candidates.value()).spliterator(), false).filter(Objects::nonNull).toList();
        if (nonNullValues.isEmpty()) {
            return new MatchNoDocsQuery("Cannot match unless there is at least one non-null candidate");
        }
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        booleanQuery.setMinimumNumberShouldMatch(1);
        for (Object value : nonNullValues) {
            booleanQuery.add(CmpOperator.toQuery(this.comparison.innerOpName, probe, value), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery.build();
    }

    @Override
    protected Query literalMatchesAnyArrayRef(Function any, Literal<?> probe, Reference candidates, LuceneQueryBuilder.Context context) {
        try {
            return CmpOperator.toQuery(this.comparison.inverseInnerOpName, candidates, probe.value());
        }
        catch (ClassCastException | IllegalArgumentException ex) {
            throw new UnsupportedFeatureException("Cannot use `" + this.comparison.symbol + " ANY` if left side is an array");
        }
    }

    public static enum Comparison {
        GT(ComparisonExpression.Type.GREATER_THAN, ComparisonExpression.Type.LESS_THAN){

            @Override
            boolean isMatch(int compareToResult) {
                return compareToResult > 0;
            }
        }
        ,
        GTE(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, ComparisonExpression.Type.LESS_THAN_OR_EQUAL){

            @Override
            boolean isMatch(int compareToResult) {
                return compareToResult >= 0;
            }
        }
        ,
        LT(ComparisonExpression.Type.LESS_THAN, ComparisonExpression.Type.GREATER_THAN){

            @Override
            boolean isMatch(int compareToResult) {
                return compareToResult < 0;
            }
        }
        ,
        LTE(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, ComparisonExpression.Type.GREATER_THAN_OR_EQUAL){

            @Override
            boolean isMatch(int compareToResult) {
                return compareToResult <= 0;
            }
        };

        private final String innerOpName;
        private final String opName;
        private final String inverseInnerOpName;
        private final String symbol;

        private Comparison(ComparisonExpression.Type cmpExpressionType, ComparisonExpression.Type inverseComparison) {
            this.symbol = cmpExpressionType.getValue();
            this.innerOpName = "op_" + this.symbol;
            this.opName = "any_" + this.symbol;
            this.inverseInnerOpName = "op_" + inverseComparison.getValue();
        }

        public String opName() {
            return this.opName;
        }

        abstract boolean isMatch(int var1);
    }
}

