/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.cluster;

import io.crate.expression.reference.sys.check.AbstractSysCheck;
import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocSchemaInfo;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class NumberOfPartitionsSysCheck
extends AbstractSysCheck {
    private static final int ID = 2;
    private static final String DESCRIPTION = "The total number of partitions of one or more partitioned tables should not be greater than 1000. A large amount of shards can significantly reduce performance.";
    private static final int PARTITIONS_THRESHOLD = 1000;
    private final Schemas schemas;
    private final ClusterService clusterService;

    @Inject
    public NumberOfPartitionsSysCheck(NodeContext nodeContext, ClusterService clusterService) {
        super(2, DESCRIPTION, SysCheck.Severity.MEDIUM);
        this.schemas = nodeContext.schemas();
        this.clusterService = clusterService;
    }

    @Override
    public boolean isValid() {
        Metadata metadata = this.clusterService.state().metadata();
        for (SchemaInfo schemaInfo : this.schemas) {
            if (!(schemaInfo instanceof DocSchemaInfo)) continue;
            DocSchemaInfo docSchemaInfo = (DocSchemaInfo)schemaInfo;
            for (TableInfo table : docSchemaInfo.getTables()) {
                DocTableInfo docTableInfo = (DocTableInfo)table;
                if (!docTableInfo.isPartitioned() || docTableInfo.getPartitionNames(metadata).size() <= 1000) continue;
                return false;
            }
        }
        return true;
    }
}

