/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.node;

import io.crate.expression.reference.sys.node.NodeStatsContext;
import io.crate.expression.reference.sys.node.Ports;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.sys.SysNodesTableInfo;
import io.crate.monitor.ExtendedNodeInfo;
import io.crate.protocols.ConnectionStats;
import io.crate.protocols.postgres.PostgresNetty;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.fs.FsService;
import org.elasticsearch.monitor.jvm.JvmService;
import org.elasticsearch.monitor.os.OsService;
import org.elasticsearch.monitor.process.ProcessService;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class NodeStatsContextFieldResolver {
    private static final Logger LOGGER = LogManager.getLogger(NodeStatsContextFieldResolver.class);
    private final Supplier<DiscoveryNode> localNode;
    private final Supplier<TransportAddress> boundHttpAddress;
    private final Supplier<ConnectionStats> httpStats;
    private final ThreadPool threadPool;
    private final ExtendedNodeInfo extendedNodeInfo;
    private final Supplier<ConnectionStats> psqlStats;
    private final Supplier<TransportAddress> boundPostgresAddress;
    private final Supplier<ConnectionStats> transportStats;
    private final ProcessService processService;
    private final OsService osService;
    private final JvmService jvmService;
    private final FsService fsService;
    private final LongSupplier clusterStateVersion;
    private final Map<ColumnIdent, Consumer<NodeStatsContext>> columnIdentToContext = Map.ofEntries(Map.entry(SysNodesTableInfo.Columns.ID, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.id(NodeStatsContextFieldResolver.this.localNode.get().getId());
        }
    }), Map.entry(SysNodesTableInfo.Columns.NAME, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.name(NodeStatsContextFieldResolver.this.localNode.get().getName());
        }
    }), Map.entry(SysNodesTableInfo.Columns.HOSTNAME, context -> {
        try {
            context.hostname(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Cannot resolve the hostname.", (Throwable)e);
        }
    }), Map.entry(SysNodesTableInfo.Columns.REST_URL, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            DiscoveryNode node = NodeStatsContextFieldResolver.this.localNode.get();
            if (node != null) {
                String url = node.getAttributes().get("http_address");
                context.restUrl(url);
            }
        }
    }), Map.entry(SysNodesTableInfo.Columns.ATTRIBUTES, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(NodeStatsContextFieldResolver.this.localNode.get().getAttributes());
            attrs.remove("http_address");
            context.attributes(Collections.unmodifiableMap(attrs));
        }
    }), Map.entry(SysNodesTableInfo.Columns.PORT, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            Integer http = Ports.portFromAddress(NodeStatsContextFieldResolver.this.boundHttpAddress.get());
            Integer transport = Ports.portFromAddress(NodeStatsContextFieldResolver.this.localNode.get().getAddress());
            Integer pgsql = Ports.portFromAddress(NodeStatsContextFieldResolver.this.boundPostgresAddress.get());
            context.httpPort(http);
            context.transportPort(transport);
            context.pgPort(pgsql);
        }
    }), Map.entry(SysNodesTableInfo.Columns.CLUSTER_STATE_VERSION, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.clusterStateVersion(NodeStatsContextFieldResolver.this.clusterStateVersion.getAsLong());
        }
    }), Map.entry(SysNodesTableInfo.Columns.LOAD, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.extendedOsStats(NodeStatsContextFieldResolver.this.extendedNodeInfo.osStats());
        }
    }), Map.entry(SysNodesTableInfo.Columns.MEM, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.osStats(NodeStatsContextFieldResolver.this.osService.stats());
        }
    }), Map.entry(SysNodesTableInfo.Columns.HEAP, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.jvmStats(NodeStatsContextFieldResolver.this.jvmService.stats());
        }
    }), Map.entry(SysNodesTableInfo.Columns.VERSION, context -> {
        context.version(Version.CURRENT);
        context.build(Build.CURRENT);
    }), Map.entry(SysNodesTableInfo.Columns.THREAD_POOLS, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.threadPools(NodeStatsContextFieldResolver.this.threadPool.stats());
        }
    }), Map.entry(SysNodesTableInfo.Columns.NETWORK, context -> {}), Map.entry(SysNodesTableInfo.Columns.CONNECTIONS, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext nodeStatsContext) {
            nodeStatsContext.httpStats(NodeStatsContextFieldResolver.this.httpStats.get());
            nodeStatsContext.psqlStats(NodeStatsContextFieldResolver.this.psqlStats.get());
            nodeStatsContext.transportStats(NodeStatsContextFieldResolver.this.transportStats.get());
        }
    }), Map.entry(SysNodesTableInfo.Columns.OS, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.timestamp(System.currentTimeMillis());
            context.extendedOsStats(NodeStatsContextFieldResolver.this.extendedNodeInfo.osStats());
        }
    }), Map.entry(SysNodesTableInfo.Columns.OS_INFO, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.osInfo(NodeStatsContextFieldResolver.this.osService.info());
        }
    }), Map.entry(SysNodesTableInfo.Columns.PROCESS, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.processStats(NodeStatsContextFieldResolver.this.processService.stats());
        }
    }), Map.entry(SysNodesTableInfo.Columns.FS, new Consumer<NodeStatsContext>(){

        @Override
        public void accept(NodeStatsContext context) {
            context.fsInfo(NodeStatsContextFieldResolver.this.fsService.stats());
        }
    }));

    @Inject
    public NodeStatsContextFieldResolver(ClusterService clusterService, NodeService nodeService, @Nullable HttpServerTransport httpServerTransport, TransportService transportService, ThreadPool threadPool, ExtendedNodeInfo extendedNodeInfo, PostgresNetty postgresNetty) {
        this(clusterService::localNode, nodeService.getMonitorService(), () -> httpServerTransport == null ? null : httpServerTransport.boundAddress().publishAddress(), () -> httpServerTransport == null ? null : httpServerTransport.stats(), threadPool, extendedNodeInfo, postgresNetty::stats, () -> {
            BoundTransportAddress boundTransportAddress = postgresNetty.boundAddress();
            if (boundTransportAddress == null) {
                return null;
            }
            return boundTransportAddress.publishAddress();
        }, transportService::stats, () -> clusterService.state().version());
    }

    @VisibleForTesting
    NodeStatsContextFieldResolver(Supplier<DiscoveryNode> localNode, MonitorService monitorService, Supplier<TransportAddress> boundHttpAddress, Supplier<ConnectionStats> httpStats, ThreadPool threadPool, ExtendedNodeInfo extendedNodeInfo, Supplier<ConnectionStats> psqlStats, Supplier<TransportAddress> boundPostgresAddress, Supplier<ConnectionStats> transportStats, LongSupplier clusterStateVersion) {
        this.localNode = localNode;
        this.processService = monitorService.processService();
        this.osService = monitorService.osService();
        this.jvmService = monitorService.jvmService();
        this.fsService = monitorService.fsService();
        this.httpStats = httpStats;
        this.boundHttpAddress = boundHttpAddress;
        this.threadPool = threadPool;
        this.extendedNodeInfo = extendedNodeInfo;
        this.psqlStats = psqlStats;
        this.boundPostgresAddress = boundPostgresAddress;
        this.transportStats = transportStats;
        this.clusterStateVersion = clusterStateVersion;
    }

    public NodeStatsContext forTopColumnIdents(Collection<ColumnIdent> topColumnIdents) {
        NodeStatsContext context = new NodeStatsContext(true);
        if (topColumnIdents.isEmpty()) {
            return context;
        }
        for (ColumnIdent column : topColumnIdents) {
            this.consumerForTopColumnIdent(column).accept(context);
        }
        return context;
    }

    private Consumer<NodeStatsContext> consumerForTopColumnIdent(ColumnIdent columnIdent) {
        Consumer<NodeStatsContext> consumer = this.columnIdentToContext.get(columnIdent);
        if (consumer == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot resolve NodeStatsContext field for \"%s\" column ident.", columnIdent));
        }
        return consumer;
    }
}

