/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;

public class ArrayAppendFunction
extends Scalar<List<Object>, Object> {
    public static final String NAME = "array_append";
    private final DataType<?> innerType;
    private final boolean calledByOperator;

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), TypeSignature.parse("E")).returnType(TypeSignature.parse("array(E)")).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), ArrayAppendFunction::new);
    }

    ArrayAppendFunction(Signature signature, BoundSignature boundSignature) {
        this(signature, boundSignature, false);
    }

    ArrayAppendFunction(Signature signature, BoundSignature boundSignature, boolean calledByOperator) {
        super(signature, boundSignature);
        this.innerType = ((ArrayType)boundSignature.returnType()).innerType();
        this.calledByOperator = calledByOperator;
    }

    @Override
    public final List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        List values = (List)args[0].value();
        Object valueToAdd = args[1].value();
        if (values != null) {
            for (Object value : values) {
                resultList.add(this.innerType.sanitizeValue(value));
            }
        }
        if (valueToAdd == null && this.calledByOperator) {
            return resultList;
        }
        resultList.add(this.innerType.sanitizeValue(valueToAdd));
        return resultList;
    }
}

