/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.StringJoiner;

class ArrayToStringFunction
extends Scalar<String, Object> {
    private static final FunctionName FQN = new FunctionName("pg_catalog", "array_to_string");

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), ArrayToStringFunction::new);
        module.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), ArrayToStringFunction::new);
    }

    private ArrayToStringFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        ArrayArgumentValidators.ensureInnerTypeIsNotUndefined(boundSignature.argTypes(), FQN.name());
    }

    @Override
    @SafeVarargs
    public final String evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
        List values = (List)args[0].value();
        if (values == null) {
            return null;
        }
        String separator = (String)args[1].value();
        if (separator == null) {
            return null;
        }
        String nullString = null;
        if (args.length == 3) {
            nullString = (String)args[2].value();
        }
        StringJoiner joiner = new StringJoiner(separator);
        for (Object value : values) {
            if (value != null) {
                joiner.add(DataTypes.STRING.implicitCast(value));
                continue;
            }
            if (nullString == null) continue;
            joiner.add(nullString);
        }
        return joiner.toString();
    }
}

