/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;

public class ArrayUnnestFunction
extends Scalar<List<Object>, List<List<Object>>> {
    public static final String NAME = "array_unnest";
    public static final Signature SIGNATURE = Signature.builder("array_unnest", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(array(E))")).returnType(TypeSignature.parse("array(E)")).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build();

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, ArrayUnnestFunction::new);
    }

    public static Symbol unnest(Symbol arg, int dimensions) {
        for (int i = 0; i < dimensions; ++i) {
            DataType<?> valueType = arg.valueType();
            assert (valueType instanceof ArrayType) : "Argument to unnest must be an array, not: " + String.valueOf(valueType);
            DataType returnType = ((ArrayType)valueType).innerType();
            arg = new Function(SIGNATURE, List.of(arg), returnType);
        }
        return arg;
    }

    public ArrayUnnestFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<List<List<Object>>> ... args) {
        List values = (List)args[0].value();
        if (values == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (List innerValues : values) {
            if (innerValues == null) continue;
            result.addAll(innerValues);
        }
        return result;
    }
}

