/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.EnumSet;

public final class CurrentDateFunction
extends Scalar<Long, String> {
    public static final String NAME = "curdate";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new TypeSignature[0]).returnType(DataTypes.DATE.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), CurrentDateFunction::new);
    }

    public CurrentDateFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
        long millis = txnCtx.currentInstant().toEpochMilli();
        return millis - millis % 86400000L;
    }
}

