/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.Extract;
import io.crate.types.DataTypes;
import io.crate.types.TimestampType;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.common.joda.Joda;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;

public class ExtractFunctions {
    public static final String NAME_PREFIX = "extract_";
    private static final long YEAR_IN_SECONDS = 31536000L;
    private static final long MONTH_IN_SECONDS = 2592000L;
    private static final long WEEK_IN_SECONDS = 604800L;
    private static final long DAY_IN_SECONDS = 86400L;
    private static final long HOUR_IN_SECONDS = 3600L;
    private static final long MINUTE_IN_SECONDS = 60L;

    public static void register(Functions.Builder module) {
        List<TsFieldWithDateTimeField> fieldsMapWithIntReturn = List.of(new TsFieldWithDateTimeField(Extract.Field.CENTURY, ISOChronology.getInstanceUTC().centuryOfEra()), new TsFieldWithDateTimeField(Extract.Field.YEAR, ISOChronology.getInstanceUTC().year()), new TsFieldWithDateTimeField(Extract.Field.QUARTER, Joda.QUARTER_OF_YEAR.getField((Chronology)ISOChronology.getInstanceUTC())), new TsFieldWithDateTimeField(Extract.Field.MONTH, ISOChronology.getInstanceUTC().monthOfYear()), new TsFieldWithDateTimeField(Extract.Field.WEEK, ISOChronology.getInstanceUTC().weekOfWeekyear()), new TsFieldWithDateTimeField(Extract.Field.DAY, ISOChronology.getInstanceUTC().dayOfMonth()), new TsFieldWithDateTimeField(Extract.Field.DAY_OF_MONTH, ISOChronology.getInstanceUTC().dayOfMonth()), new TsFieldWithDateTimeField(Extract.Field.DAY_OF_WEEK, ISOChronology.getInstanceUTC().dayOfWeek()), new TsFieldWithDateTimeField(Extract.Field.DAY_OF_YEAR, ISOChronology.getInstanceUTC().dayOfYear()), new TsFieldWithDateTimeField(Extract.Field.HOUR, ISOChronology.getInstanceUTC().hourOfDay()), new TsFieldWithDateTimeField(Extract.Field.MINUTE, ISOChronology.getInstanceUTC().minuteOfHour()), new TsFieldWithDateTimeField(Extract.Field.SECOND, ISOChronology.getInstanceUTC().secondOfMinute()));
        for (TimestampType argType : List.of(DataTypes.TIMESTAMPZ, DataTypes.TIMESTAMP)) {
            for (TsFieldWithDateTimeField entry : fieldsMapWithIntReturn) {
                DateTimeField dtf = entry.dtf();
                module.add(Signature.builder(ExtractFunctions.functionNameFrom(entry.extractField()), FunctionType.SCALAR).argumentTypes(argType.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<Number, Long>((Signature)signature, (BoundSignature)boundSignature, argType, arg_0 -> ((DateTimeField)dtf).get(arg_0)));
            }
            module.add(Signature.builder(ExtractFunctions.functionNameFrom(Extract.Field.EPOCH), FunctionType.SCALAR).argumentTypes(argType.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<Double, Long>((Signature)signature, (BoundSignature)boundSignature, argType, v -> (double)v.longValue() / 1000.0));
        }
        List<IntervalFieldWithFunction> intervalFieldsMapWithIntReturn = List.of(new IntervalFieldWithFunction(Extract.Field.YEAR, p -> p.get(DurationFieldType.years())), new IntervalFieldWithFunction(Extract.Field.QUARTER, p -> p.get(DurationFieldType.months()) / 4), new IntervalFieldWithFunction(Extract.Field.MONTH, p -> p.get(DurationFieldType.months())), new IntervalFieldWithFunction(Extract.Field.DAY, p -> p.get(DurationFieldType.days())), new IntervalFieldWithFunction(Extract.Field.HOUR, p -> p.get(DurationFieldType.hours())), new IntervalFieldWithFunction(Extract.Field.MINUTE, p -> p.get(DurationFieldType.minutes())), new IntervalFieldWithFunction(Extract.Field.SECOND, p -> p.get(DurationFieldType.seconds())));
        for (IntervalFieldWithFunction entry : intervalFieldsMapWithIntReturn) {
            Function<Period, Integer> function = entry.function();
            module.add(Signature.builder(ExtractFunctions.functionNameFrom(entry.extractField()), FunctionType.SCALAR).argumentTypes(DataTypes.INTERVAL.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<Number, Period>((Signature)signature, (BoundSignature)boundSignature, DataTypes.INTERVAL, function::apply));
        }
        module.add(Signature.builder(ExtractFunctions.functionNameFrom(Extract.Field.EPOCH), FunctionType.SCALAR).argumentTypes(DataTypes.INTERVAL.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<Double, Period>((Signature)signature, (BoundSignature)boundSignature, DataTypes.INTERVAL, ExtractFunctions::toMillis));
    }

    private static Double toMillis(Period period) {
        double result = 0.0;
        result += (double)((long)period.getYears() * 31536000L);
        result += (double)((long)(period.getYears() * 6) * 3600L);
        result += (double)((long)period.getMonths() * 2592000L);
        result += (double)((long)period.getWeeks() * 604800L);
        result += (double)((long)period.getDays() * 86400L);
        result += (double)((long)period.getHours() * 3600L);
        result += (double)((long)period.getMinutes() * 60L);
        result += (double)period.getSeconds();
        return result += (double)period.getMillis() / 1000.0;
    }

    public static String functionNameFrom(Extract.Field field) {
        switch (field) {
            case CENTURY: 
            case YEAR: 
            case QUARTER: 
            case MONTH: 
            case WEEK: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case EPOCH: {
                return NAME_PREFIX + String.valueOf(field);
            }
            case DAY: {
                return NAME_PREFIX + String.valueOf(Extract.Field.DAY);
            }
            case DAY_OF_MONTH: {
                return NAME_PREFIX + String.valueOf(Extract.Field.DAY_OF_MONTH);
            }
            case DAY_OF_WEEK: 
            case DOW: {
                return NAME_PREFIX + String.valueOf(Extract.Field.DAY_OF_WEEK);
            }
            case DAY_OF_YEAR: 
            case DOY: {
                return NAME_PREFIX + String.valueOf(Extract.Field.DAY_OF_YEAR);
            }
        }
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Extract( %s from <expression>) is not supported", field));
    }

    private record TsFieldWithDateTimeField(Extract.Field extractField, DateTimeField dtf) {
    }

    private record IntervalFieldWithFunction(Extract.Field extractField, Function<Period, Integer> function) {
    }
}

