/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.expression.scalar.HasPrivilegeFunction;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.Schemas;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Permission;
import io.crate.role.Privilege;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;

public class HasDatabasePrivilegeFunction {
    public static final FunctionName NAME = new FunctionName("pg_catalog", "has_database_privilege");

    public static boolean checkByDbName(Roles roles, Role user, Object db, Collection<Permission> permissions, Schemas schemas) {
        if (!"crate".equals(db)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "database \"%s\" does not exist", db));
        }
        return HasDatabasePrivilegeFunction.checkPrivileges(user, permissions);
    }

    public static boolean checkByDbOid(Roles roles, Role user, Object db, Collection<Permission> permissions, Schemas schemas) {
        if (0 != (Integer)db) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "database with OID \"%s\" does not exist", db));
        }
        return HasDatabasePrivilegeFunction.checkPrivileges(user, permissions);
    }

    private static boolean checkPrivileges(Role user, Collection<Permission> permissions) {
        if (permissions.contains((Object)Permission.DQL)) {
            return true;
        }
        boolean result = true;
        if (permissions.contains((Object)Permission.DML)) {
            result = false;
        }
        if (permissions.contains((Object)Permission.DDL)) {
            result = HasDatabasePrivilegeFunction.hasCreatePrivilege(user);
        }
        return result;
    }

    private static boolean hasCreatePrivilege(Role user) {
        if (user.isSuperUser()) {
            return true;
        }
        for (Privilege p : user.privileges()) {
            if (p.subject().permission() != Permission.DDL || p.subject().securable() != Securable.SCHEMA && p.subject().securable() != Securable.CLUSTER) continue;
            return true;
        }
        return false;
    }

    public static Collection<Permission> parsePermissions(String permissionNames) {
        String[] permissions;
        HashSet<Permission> toCheck = new HashSet<Permission>();
        block12: for (String p : permissions = permissionNames.toLowerCase(Locale.ENGLISH).split(",")) {
            switch (p = p.trim()) {
                case "connect": {
                    toCheck.add(Permission.DQL);
                    continue block12;
                }
                case "create": {
                    toCheck.add(Permission.DDL);
                    continue block12;
                }
                case "temp": {
                    toCheck.add(Permission.DML);
                    continue block12;
                }
                case "temporary": {
                    toCheck.add(Permission.DML);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unrecognized permission: %s", p));
                }
            }
        }
        return toCheck;
    }

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasDatabasePrivilegeFunction::checkByDbName, HasDatabasePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasDatabasePrivilegeFunction::checkByDbOid, HasDatabasePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasDatabasePrivilegeFunction::checkByDbName, HasDatabasePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasDatabasePrivilegeFunction::checkByDbOid, HasDatabasePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByOid, HasDatabasePrivilegeFunction::checkByDbName, HasDatabasePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByOid, HasDatabasePrivilegeFunction::checkByDbOid, HasDatabasePrivilegeFunction::parsePermissions));
    }

    private HasDatabasePrivilegeFunction() {
    }
}

