/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringToArrayFunction
extends Scalar<List<String>, String> {
    private static final String NAME = "string_to_array";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING_ARRAY.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), StringToArrayFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING_ARRAY.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), StringToArrayFunction::new);
    }

    public StringToArrayFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public List<String> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
        assert (args.length == 2 || args.length == 3) : "number of args must be 2 or 3";
        String str = (String)args[0].value();
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return List.of();
        }
        String separator = (String)args[1].value();
        String nullStr = null;
        if (args.length == 3) {
            nullStr = (String)args[2].value();
        }
        return StringToArrayFunction.split(str, separator, nullStr);
    }

    private static List<String> split(@NotNull String str, @Nullable String separator, @Nullable String nullStr) {
        String subStr;
        if (separator == null) {
            ArrayList<String> subStrings = new ArrayList<String>(str.length());
            for (int i = 0; i < str.length(); ++i) {
                String subStr2 = String.valueOf(str.charAt(i));
                subStrings.add(StringToArrayFunction.setToNullIfMatch(subStr2, nullStr));
            }
            return subStrings;
        }
        if (separator.isEmpty()) {
            return Collections.singletonList(StringToArrayFunction.setToNullIfMatch(str, nullStr));
        }
        ArrayList<String> subStrings = new ArrayList<String>();
        int start = 0;
        int pos = str.indexOf(separator);
        while (pos >= start) {
            subStr = pos > start ? str.substring(start, pos) : "";
            start = pos + separator.length();
            pos = str.indexOf(separator, start);
            subStrings.add(StringToArrayFunction.setToNullIfMatch(subStr, nullStr));
        }
        subStr = str.substring(start);
        subStrings.add(StringToArrayFunction.setToNullIfMatch(subStr, nullStr));
        return subStrings;
    }

    @Nullable
    private static String setToNullIfMatch(String subStr, String nullStr) {
        if (Objects.equals(subStr, nullStr)) {
            return null;
        }
        return subStr;
    }
}

