/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import ch.obermuhlner.math.big.BigDecimalMath;
import io.crate.expression.scalar.BinaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TimestampType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BinaryOperator;

public class ArithmeticFunctions {
    public static void register(Functions.Builder builder) {
        for (Operations op : Operations.values()) {
            builder.add(Signature.builder(op.toString(), FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).features(op.features).build(), (signature, boundSignature) -> new BinaryScalar<Integer>(op.integerFunction, (Signature)signature, (BoundSignature)boundSignature, DataTypes.INTEGER));
            builder.add(Signature.builder(op.toString(), FunctionType.SCALAR).argumentTypes(DataTypes.LONG.getTypeSignature(), DataTypes.LONG.getTypeSignature()).returnType(DataTypes.LONG.getTypeSignature()).features(op.features).build(), (signature, boundSignature) -> new BinaryScalar<Long>(op.longFunction, (Signature)signature, (BoundSignature)boundSignature, DataTypes.LONG));
            if (op != Operations.SUBTRACT) {
                for (TimestampType type : List.of(DataTypes.TIMESTAMP, DataTypes.TIMESTAMPZ)) {
                    builder.add(Signature.builder(op.toString(), FunctionType.SCALAR).argumentTypes(type.getTypeSignature(), type.getTypeSignature()).returnType(type.getTypeSignature()).features(op.features).build(), (signature, boundSignature) -> new BinaryScalar<Long>(op.longFunction, (Signature)signature, (BoundSignature)boundSignature, type));
                }
            }
            builder.add(Signature.builder(op.toString(), FunctionType.SCALAR).argumentTypes(DataTypes.FLOAT.getTypeSignature(), DataTypes.FLOAT.getTypeSignature()).returnType(DataTypes.FLOAT.getTypeSignature()).features(op.features).build(), (signature, boundSignature) -> new BinaryScalar<Float>(op.floatFunction, (Signature)signature, (BoundSignature)boundSignature, DataTypes.FLOAT));
            builder.add(Signature.builder(op.toString(), FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(op.features).build(), (signature, boundSignature) -> new BinaryScalar<Double>(op.doubleFunction, (Signature)signature, (BoundSignature)boundSignature, DataTypes.DOUBLE));
            builder.add(Signature.builder(op.toString(), FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature(), DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(op.features).build(), (signature, boundSignature) -> new BinaryScalar<BigDecimal>(op.bdFunction, (Signature)signature, (BoundSignature)boundSignature, DataTypes.NUMERIC));
        }
        builder.add(Signature.builder("power", FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new BinaryScalar<Double>(Math::pow, (Signature)signature, (BoundSignature)boundSignature, DataTypes.DOUBLE));
        builder.add(Signature.builder("power", FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature(), DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new BinaryScalar<BigDecimal>((arg1, arg2) -> BigDecimalMath.pow((BigDecimal)arg1, (BigDecimal)arg2, (MathContext)MathContext.DECIMAL128), (Signature)signature, (BoundSignature)boundSignature, DataTypes.NUMERIC));
    }

    private static enum Operations {
        ADD(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.COMPARISON_REPLACEMENT, Scalar.Feature.STRICTNULL), Math::addExact, Double::sum, Math::addExact, Float::sum, BigDecimal::add),
        SUBTRACT(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL), Math::subtractExact, (arg0, arg1) -> arg0 - arg1, Math::subtractExact, (arg0, arg1) -> Float.valueOf(arg0.floatValue() - arg1.floatValue()), BigDecimal::subtract),
        MULTIPLY(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL), Math::multiplyExact, (arg0, arg1) -> arg0 * arg1, Math::multiplyExact, (arg0, arg1) -> Float.valueOf(arg0.floatValue() * arg1.floatValue()), BigDecimal::multiply),
        DIVIDE(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL), (arg0, arg1) -> arg0 / arg1, (arg0, arg1) -> arg0 / arg1, (arg0, arg1) -> arg0 / arg1, (arg0, arg1) -> Float.valueOf(arg0.floatValue() / arg1.floatValue()), (arg0, arg1) -> arg0.divide((BigDecimal)arg1, MathContext.DECIMAL64)),
        MODULUS(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL), (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> Float.valueOf(arg0.floatValue() % arg1.floatValue()), BigDecimal::remainder),
        MOD(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL), (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> Float.valueOf(arg0.floatValue() % arg1.floatValue()), BigDecimal::remainder);

        private final Set<Scalar.Feature> features;
        private final BinaryOperator<Integer> integerFunction;
        private final BinaryOperator<Double> doubleFunction;
        private final BinaryOperator<Long> longFunction;
        private final BinaryOperator<Float> floatFunction;
        private final BinaryOperator<BigDecimal> bdFunction;

        private Operations(Set<Scalar.Feature> features, BinaryOperator<Integer> integerFunction, BinaryOperator<Double> doubleFunction, BinaryOperator<Long> longFunction, BinaryOperator<Float> floatFunction, BinaryOperator<BigDecimal> bdFunction) {
            this.features = features;
            this.doubleFunction = doubleFunction;
            this.integerFunction = integerFunction;
            this.longFunction = longFunction;
            this.floatFunction = floatFunction;
            this.bdFunction = bdFunction;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static class Names {
        public static final String ADD = "add";
        public static final String SUBTRACT = "subtract";
        public static final String MULTIPLY = "multiply";
        public static final String DIVIDE = "divide";
        public static final String POWER = "power";
        public static final String MODULUS = "modulus";
        public static final String MOD = "mod";
    }
}

