/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.math.BigDecimal;

public final class NegateFunctions {
    public static final String NAME = "_negate";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("double precision")).returnType(TypeSignature.parse("double precision")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).forbidCoercion().build(), (signature, boundSignature) -> new UnaryScalar<Double, Double>((Signature)signature, (BoundSignature)boundSignature, DataTypes.DOUBLE, x -> x * -1.0));
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.FLOAT.getTypeSignature()).returnType(DataTypes.FLOAT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).forbidCoercion().build(), (signature, boundSignature) -> new UnaryScalar<Float, Float>((Signature)signature, (BoundSignature)boundSignature, DataTypes.FLOAT, x -> Float.valueOf(x.floatValue() * -1.0f)));
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("integer")).returnType(TypeSignature.parse("integer")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).forbidCoercion().build(), (signature, boundSignature) -> new UnaryScalar<Integer, Integer>((Signature)signature, (BoundSignature)boundSignature, DataTypes.INTEGER, x -> x * -1));
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("bigint")).returnType(TypeSignature.parse("bigint")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).forbidCoercion().build(), (signature, boundSignature) -> new UnaryScalar<Long, Long>((Signature)signature, (BoundSignature)boundSignature, DataTypes.LONG, x -> x * -1L));
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("smallint")).returnType(TypeSignature.parse("smallint")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).forbidCoercion().build(), (signature, boundSignature) -> new UnaryScalar<Short, Short>((Signature)signature, (BoundSignature)boundSignature, DataTypes.SHORT, x -> (short)(x * -1)));
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).forbidCoercion().build(), (signature, boundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)signature, (BoundSignature)boundSignature, DataTypes.NUMERIC, BigDecimal::negate));
    }
}

