/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class RoundFunction {
    public static final String NAME = "round";

    private RoundFunction() {
    }

    public static void register(Functions.Builder builder) {
        for (DataType<? extends Number> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            TypeSignature typeSignature = type.getTypeSignature();
            DataType<?> returnType = DataTypes.getIntegralReturnType(type);
            assert (returnType != null) : "Could not get integral type of " + String.valueOf(type);
            builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(typeSignature).returnType(returnType.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> {
                if (returnType.equals(DataTypes.INTEGER)) {
                    return new UnaryScalar<Integer, Number>((Signature)signature, (BoundSignature)boundSignature, (DataType<Number>)type, x -> Math.round(x.floatValue()));
                }
                return new UnaryScalar<Long, Number>((Signature)signature, (BoundSignature)boundSignature, (DataType<Number>)type, x -> Math.round(x.doubleValue()));
            });
        }
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)signature, (BoundSignature)boundSignature, DataTypes.NUMERIC, x -> x.setScale(0, RoundingMode.HALF_UP)));
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), RoundFunction::roundWithPrecision);
    }

    private static Scalar<Number, Number> roundWithPrecision(Signature signature, BoundSignature boundSignature) {
        return new Scalar<Number, Number>(signature, boundSignature){

            @Override
            public BigDecimal evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Number> ... args) {
                Number n = (Number)args[0].value();
                Number nd = (Number)args[1].value();
                if (n == null || nd == null) {
                    return null;
                }
                int numDecimals = nd.intValue();
                BigDecimal val = n instanceof BigDecimal ? (BigDecimal)n : (n instanceof Long ? BigDecimal.valueOf(n.longValue()) : BigDecimal.valueOf(n.doubleValue()));
                if (numDecimals < 0) {
                    return val.movePointRight(numDecimals).setScale(0, RoundingMode.HALF_UP).movePointLeft(numDecimals);
                }
                return val.setScale(numDecimals, RoundingMode.HALF_UP);
            }
        };
    }
}

