/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.DoubleScalar;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.math.BigDecimal;

public class SignFunction {
    public static final String NAME = "sign";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> {
            DataType<?> argType = boundSignature.argTypes().getFirst();
            return new UnaryScalar<BigDecimal, Object>((Signature)signature, (BoundSignature)boundSignature, (DataType<Object>)argType, x -> BigDecimal.valueOf(Math.signum(((Number)argType.sanitizeValue(x)).longValue())));
        });
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new DoubleScalar((Signature)signature, (BoundSignature)boundSignature, Math::signum));
    }
}

