/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TimestampType;
import java.util.List;
import org.joda.time.Period;
import org.joda.time.PeriodType;

public class SubtractTimestampScalar
extends Scalar<Period, Object> {
    public static void register(Functions.Builder module) {
        for (TimestampType timestampType : List.of(DataTypes.TIMESTAMP, DataTypes.TIMESTAMPZ)) {
            module.add(Signature.builder("subtract", FunctionType.SCALAR).argumentTypes(timestampType.getTypeSignature(), timestampType.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), SubtractTimestampScalar::new);
        }
    }

    public SubtractTimestampScalar(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Period evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        Long start = (Long)args[1].value();
        Long end = (Long)args[0].value();
        if (end == null || start == null) {
            return null;
        }
        return new Period(end - start).normalizedStandard(PeriodType.yearMonthDayTime());
    }
}

