/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.cast;

import io.crate.data.Input;
import io.crate.exceptions.ConversionException;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.role.Roles;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ImplicitCastFunction
extends Scalar<Object, Object> {
    public static final String NAME = "_cast";
    public static final Signature SIGNATURE = Signature.builder("_cast", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E"), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.UNDEFINED.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build();
    @Nullable
    private final DataType<?> targetType;

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, ImplicitCastFunction::new);
    }

    private ImplicitCastFunction(Signature signature, BoundSignature boundSignature) {
        this(signature, boundSignature, null);
    }

    private ImplicitCastFunction(Signature signature, BoundSignature boundSignature, @Nullable DataType<?> targetType) {
        super(signature, boundSignature);
        this.targetType = targetType;
    }

    @Override
    public Scalar<Object, Object> compile(List<Symbol> args, String currentUser, Roles roles) {
        assert (args.size() == 2) : "number of arguments must be 2";
        Symbol input = args.get(1);
        if (input instanceof Input) {
            String targetTypeValue = (String)((Input)input).value();
            TypeSignature targetTypeSignature = TypeSignature.parse(targetTypeValue);
            DataType<?> targetType = targetTypeSignature.createType();
            return new ImplicitCastFunction(this.signature, this.boundSignature, targetType);
        }
        return this;
    }

    @Override
    public Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        assert (args.length == 1 || args.length == 2) : "number of args must be 1 or 2";
        Object arg = args[0].value();
        if (this.targetType == null) {
            TypeSignature targetTypeSignature = TypeSignature.parse((String)args[1].value());
            DataType<?> targetType = targetTypeSignature.createType();
            return ImplicitCastFunction.castToTargetType(targetType, arg);
        }
        return ImplicitCastFunction.castToTargetType(this.targetType, arg);
    }

    private static Object castToTargetType(DataType<?> targetType, Object arg) {
        try {
            return targetType.implicitCast(arg);
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ConversionException(arg, targetType);
        }
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol argument = symbol.arguments().get(0);
        String targetTypeAsString = (String)((Input)symbol.arguments().get(1)).value();
        DataType<?> targetType = TypeSignature.parse(targetTypeAsString).createType();
        if (argument.valueType().equals(targetType)) {
            return argument;
        }
        if (argument instanceof Input) {
            Input input = (Input)argument;
            Object value = input.value();
            try {
                return Literal.ofUnchecked(targetType, targetType.implicitCast(value));
            }
            catch (ConversionException e) {
                throw e;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ConversionException(argument, targetType);
            }
        }
        return symbol;
    }
}

