/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.GeoPointType;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.locationtech.spatial4j.shape.Point;

public final class GeoHashFunction {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("geohash", FunctionType.SCALAR).argumentTypes(DataTypes.GEO_POINT.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<String, Point>((Signature)signature, (BoundSignature)boundSignature, DataTypes.GEO_POINT, GeoHashFunction::getGeoHash));
    }

    private static String getGeoHash(Object value) {
        Point geoValue = GeoPointType.INSTANCE.sanitizeValue(value);
        return GeoHashUtils.stringEncode(geoValue.getX(), geoValue.getY());
    }
}

