/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.geo.GeoJSONUtils;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class WithinFunction
extends Scalar<Boolean, Object> {
    public static final String NAME = "within";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.GEO_SHAPE.getTypeSignature(), DataTypes.GEO_SHAPE.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), WithinFunction::new);
        for (DataType dataType : List.of(DataTypes.GEO_SHAPE, DataTypes.STRING, DataTypes.UNTYPED_OBJECT, DataTypes.UNDEFINED)) {
            module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.GEO_POINT.getTypeSignature(), dataType.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).forbidCoercion().build(), WithinFunction::new);
        }
    }

    private WithinFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 2) : "number of args must be 2";
        Object left = args[0].value();
        if (left == null) {
            return null;
        }
        Object right = args[1].value();
        if (right == null) {
            return null;
        }
        return WithinFunction.parseLeftShape(left).relate(WithinFunction.parseRightShape(right)) == SpatialRelation.WITHIN;
    }

    private static Shape parseLeftShape(Object left) {
        Shape shape;
        if (left instanceof Point) {
            Point point = (Point)left;
            shape = point;
        } else {
            shape = GeoJSONUtils.map2Shape((Map)left);
        }
        return shape;
    }

    private static Shape parseRightShape(Object right) {
        Shape shape;
        if (right instanceof String) {
            String str = (String)right;
            shape = GeoJSONUtils.wkt2Shape(str);
        } else {
            shape = GeoJSONUtils.map2Shape((Map)right);
        }
        return shape;
    }

    @Override
    public Query toQuery(Function parent, Function inner, LuceneQueryBuilder.Context context) {
        Symbol symbol;
        if (parent.name().equals("op_=") && (symbol = parent.arguments().get(1)) instanceof Literal) {
            Literal eqLiteral = (Literal)symbol;
            symbol = inner.arguments().get(0);
            if (symbol instanceof Reference) {
                Reference ref = (Reference)symbol;
                symbol = inner.arguments().get(1);
                if (symbol instanceof Literal) {
                    Literal pointOrShape = (Literal)symbol;
                    Query query = this.toQuery(ref, pointOrShape);
                    if (query == null) {
                        return null;
                    }
                    Boolean isWithin = (Boolean)eqLiteral.value();
                    if (isWithin == null) {
                        return null;
                    }
                    return isWithin != false ? query : Queries.not(query);
                }
            }
        }
        return null;
    }

    @Override
    public Query toQuery(Reference ref, Literal<?> literal) {
        Geometry geometry;
        if (ref.valueType().equals(DataTypes.GEO_SHAPE)) {
            return null;
        }
        Object geoJSON = DataTypes.GEO_SHAPE.implicitCast(literal.value());
        Shape shape = GeoJSONUtils.map2Shape((Map<String, Object>)geoJSON);
        if (shape instanceof ShapeCollection) {
            ShapeCollection collection = (ShapeCollection)shape;
            int i = 0;
            org.locationtech.jts.geom.Polygon[] polygons = new org.locationtech.jts.geom.Polygon[collection.size()];
            for (Shape s : collection.getShapes()) {
                Geometry subGeometry = JtsSpatialContext.GEO.getShapeFactory().getGeometryFrom(s);
                if (subGeometry instanceof org.locationtech.jts.geom.Polygon) {
                    org.locationtech.jts.geom.Polygon polygon = (org.locationtech.jts.geom.Polygon)subGeometry;
                    polygons[i++] = polygon;
                    continue;
                }
                throw new InvalidShapeException("Shape collection must contain only Polygon shapes.");
            }
            GeometryFactory geometryFactory = JtsSpatialContext.GEO.getShapeFactory().getGeometryFactory();
            geometry = geometryFactory.createMultiPolygon(polygons);
        } else {
            geometry = JtsSpatialContext.GEO.getShapeFactory().getGeometryFrom(shape);
        }
        return WithinFunction.getPolygonQuery(ref.storageIdent(), geometry);
    }

    private static Query getPolygonQuery(String column, Geometry geometry) {
        Coordinate[] coordinates = geometry.getCoordinates();
        if (!CoordinateArrays.isRing((Coordinate[])coordinates)) {
            coordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
            coordinates[coordinates.length - 1] = coordinates[0];
        }
        double[] lats = new double[coordinates.length];
        double[] lons = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            lats[i] = coordinates[i].y;
            lons[i] = coordinates[i].x;
        }
        return LatLonPoint.newPolygonQuery((String)column, (Polygon[])new Polygon[]{new Polygon(lats, lons, new Polygon[0])});
    }
}

