/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.postgres;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.types.DataTypes;

public class CurrentSettingFunction
extends Scalar<String, Object> {
    private static final String NAME = "current_setting";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "current_setting");
    private final SessionSettingRegistry sessionSettingRegistry;

    public static void register(Functions.Builder builder, SessionSettingRegistry sessionSettingRegistry) {
        builder.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new CurrentSettingFunction((Signature)signature, (BoundSignature)boundSignature, sessionSettingRegistry));
        builder.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new CurrentSettingFunction((Signature)signature, (BoundSignature)boundSignature, sessionSettingRegistry));
    }

    CurrentSettingFunction(Signature signature, BoundSignature boundSignature, SessionSettingRegistry sessionSettingRegistry) {
        super(signature, boundSignature);
        this.sessionSettingRegistry = sessionSettingRegistry;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        Boolean missingOk;
        assert (args.length == 1 || args.length == 2) : "number of args must be 1 or 2";
        String settingName = (String)args[0].value();
        if (settingName == null) {
            return null;
        }
        Boolean bl = missingOk = args.length == 2 ? (Boolean)args[1].value() : Boolean.FALSE;
        if (missingOk == null) {
            return null;
        }
        SessionSetting<?> sessionSetting = this.sessionSettingRegistry.settings().get(settingName);
        if (sessionSetting == null) {
            if (missingOk.booleanValue()) {
                return null;
            }
            throw new IllegalArgumentException("Unrecognised Setting: " + settingName);
        }
        return sessionSetting.getValue(txnCtx.sessionSettings());
    }
}

