/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.postgres;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.EnumSet;

public class PgBackendPidFunction
extends Scalar<Integer, Void> {
    public static final String NAME = "pg_backend_pid";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "pg_backend_pid");

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(new TypeSignature[0]).returnType(DataTypes.INTEGER.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), PgBackendPidFunction::new);
    }

    public PgBackendPidFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (symbol.arguments().size() == 0) : "function's number of arguments must be 0";
        return Literal.of(-1);
    }

    @Override
    public Integer evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 0) : "number of args must be 0";
        return -1;
    }
}

