/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public final class ChrFunction
extends Scalar<String, Object> {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("chr", FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), ChrFunction::new);
    }

    public ChrFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        assert (args.length == 1) : "chr takes exactly one argument";
        Object value = args[0].value();
        if (value == null) {
            return null;
        }
        int character = (Integer)value;
        if (character == 0) {
            throw new IllegalArgumentException("null character not permitted");
        }
        if (character > 0x10FFFF || character < 0) {
            throw new IllegalArgumentException("requested character too large for encoding: " + character);
        }
        return Character.toString((char)character);
    }
}

