/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.common.Hex;
import io.crate.common.Octal;
import io.crate.expression.scalar.BinaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public class EncodeDecodeFunction {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("encode", FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new BinaryScalar<String>(new Encode(), (Signature)signature, (BoundSignature)boundSignature, DataTypes.STRING));
        module.add(Signature.builder("decode", FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new BinaryScalar<String>(new Decode(), (Signature)signature, (BoundSignature)boundSignature, DataTypes.STRING));
    }

    private static class Decode
    implements BinaryOperator<String> {
        private Decode() {
        }

        @Override
        public String apply(String text, String format) {
            Format fmt;
            try {
                fmt = Format.valueOf(format.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Encoding format '%s' is not supported", format));
            }
            return fmt.decode(text);
        }
    }

    private static class Encode
    implements BinaryOperator<String> {
        private Encode() {
        }

        @Override
        public String apply(String bytea, String format) {
            Format fmt;
            try {
                fmt = Format.valueOf(format.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Encoding format '%s' is not supported", format));
            }
            return fmt.encode(bytea);
        }
    }

    private static enum Format {
        BASE64(bytea -> {
            byte[] text = Hex.isHexFormat((String)bytea) ? Hex.decodeHex((String)Hex.stripHexFormatFlag((String)bytea)) : Octal.decode((String)bytea);
            return Base64.getEncoder().encodeToString(text);
        }, text -> {
            byte[] value = Base64.getDecoder().decode(text.getBytes(StandardCharsets.UTF_8));
            return "\\x" + Hex.encodeHexString((byte[])value);
        }),
        HEX(bytea -> {
            if (Hex.isHexFormat((String)bytea)) {
                return Hex.stripHexFormatFlag((String)bytea);
            }
            return Hex.encodeHexString((byte[])Octal.decode((String)bytea));
        }, text -> "\\x" + Hex.validateHex((String)text, (int)0)),
        ESCAPE(bytea -> {
            if (Hex.isHexFormat((String)bytea)) {
                return Octal.encode((byte[])Hex.decodeHex((String)Hex.stripHexFormatFlag((String)bytea)));
            }
            return Octal.encode((byte[])bytea.getBytes(StandardCharsets.UTF_8));
        }, text -> "\\x" + Hex.encodeHexString((byte[])Octal.decode((String)text)));

        private final UnaryOperator<String> encode;
        private final UnaryOperator<String> decode;

        private Format(UnaryOperator<String> encode, UnaryOperator<String> decode) {
            this.encode = encode;
            this.decode = decode;
        }

        String encode(String bytea) {
            return (String)this.encode.apply(bytea);
        }

        String decode(String text) {
            return (String)this.decode.apply(text);
        }
    }
}

