/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import io.crate.types.StorageSupport;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;

public final class StartsWithFunction
extends Scalar<Boolean, String> {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("starts_with", FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), StartsWithFunction::new);
    }

    public StartsWithFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
        assert (args.length == 2) : "starts_with takes exactly two arguments";
        String text = (String)args[0].value();
        String prefix = (String)args[1].value();
        if (text == null || prefix == null) {
            return null;
        }
        return text.startsWith(prefix);
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        List<Symbol> args = function.arguments();
        Symbol symbol = args.get(0);
        if (symbol instanceof Reference) {
            Reference ref = (Reference)symbol;
            symbol = args.get(1);
            if (symbol instanceof Literal) {
                Literal prefixLiteral = (Literal)symbol;
                if (ref.indexType() != IndexType.NONE) {
                    Object value = prefixLiteral.value();
                    assert (value instanceof String) : "StartsWithFunction is registered for string types. Value must be a string";
                    if (((String)value).isEmpty()) {
                        EqQuery<?> eqQuery;
                        StorageSupport<?> storageSupport = ref.valueType().storageSupport();
                        EqQuery<?> eqQuery2 = eqQuery = storageSupport == null ? null : storageSupport.eqQuery();
                        if (eqQuery == null) {
                            return null;
                        }
                        return eqQuery.termQuery(ref.storageIdent(), value, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
                    }
                    return new PrefixQuery(new Term(ref.storageIdent(), (String)value));
                }
            }
        }
        return null;
    }
}

