/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public final class StringRepeatFunction
extends Scalar<String, Object> {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("repeat", FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), StringRepeatFunction::new);
    }

    public StringRepeatFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        assert (args.length == 2) : "repeat takes exactly two arguments";
        String text = (String)args[0].value();
        Integer repetitions = (Integer)args[1].value();
        if (text == null || repetitions == null) {
            return null;
        }
        if (repetitions <= 0) {
            return "";
        }
        return text.repeat(repetitions);
    }
}

