/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.EnumSet;
import org.jetbrains.annotations.Nullable;

public class CurrentSchemaFunction
extends Scalar<String, Object> {
    public static final String NAME = "current_schema";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "current_schema");

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(new TypeSignature[0]).returnType(DataTypes.STRING.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), CurrentSchemaFunction::new);
    }

    public CurrentSchemaFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 0) : "number of args must be 0";
        return txnCtx.sessionSettings().currentSchema();
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, @Nullable TransactionContext txnCtx, NodeContext nodeCtx) {
        if (txnCtx == null) {
            return Literal.NULL;
        }
        return Literal.of(txnCtx.sessionSettings().currentSchema());
    }
}

