/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public final class PgFunctionIsVisibleFunction
extends Scalar<Boolean, Integer> {
    public static final String NAME = "pg_function_is_visible";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), PgFunctionIsVisibleFunction::new);
    }

    public PgFunctionIsVisibleFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Integer> ... args) {
        assert (args.length == 1) : "pg_function_is_visible expects exactly 1 argument, got " + args.length;
        Integer oid = (Integer)args[0].value();
        if (oid == null) {
            return null;
        }
        return nodeCtx.functions().findFunctionSignatureByOid(oid) != null;
    }
}

