/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.analyze.FrameBoundDefinition;
import io.crate.analyze.OrderBy;
import io.crate.analyze.WindowDefinition;
import io.crate.analyze.WindowFrameDefinition;
import io.crate.common.collections.Lists;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.FunctionType;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class WindowFunction
extends Function {
    private final WindowDefinition windowDefinition;
    @Nullable
    private final Boolean ignoreNulls;

    public WindowFunction(StreamInput in) throws IOException {
        super(in);
        this.windowDefinition = new WindowDefinition(in);
        this.ignoreNulls = in.getVersion().onOrAfter(Version.V_4_7_0) ? in.readOptionalBoolean() : null;
    }

    public WindowFunction(Signature signature, List<Symbol> arguments, DataType<?> returnType, @Nullable Symbol filter, WindowDefinition windowDefinition, @Nullable Boolean ignoreNulls) {
        super(signature, arguments, returnType, filter);
        assert (signature.getType() == FunctionType.WINDOW || signature.getType() == FunctionType.AGGREGATE) : "only window and aggregate functions are allowed to be modelled over a window";
        this.windowDefinition = windowDefinition;
        this.ignoreNulls = ignoreNulls;
    }

    public WindowDefinition windowDefinition() {
        return this.windowDefinition;
    }

    @Nullable
    public Boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public boolean any(Predicate<? super Symbol> predicate) {
        if (super.any(predicate)) {
            return true;
        }
        OrderBy orderBy = this.windowDefinition.orderBy();
        if (orderBy != null) {
            for (Symbol orderSymbol : orderBy.orderBySymbols()) {
                if (!orderSymbol.any(predicate)) continue;
                return true;
            }
        }
        for (Symbol partition : this.windowDefinition.partitions()) {
            if (!partition.any(predicate)) continue;
            return true;
        }
        WindowFrameDefinition frame = this.windowDefinition.windowFrameDefinition();
        Symbol frameStart = frame.start().value();
        if (frameStart != null && frameStart.any(predicate)) {
            return true;
        }
        Symbol frameEnd = frame.end().value();
        return frameEnd != null && frameEnd.any(predicate);
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitWindowFunction(this, context);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.WINDOW_FUNCTION;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.windowDefinition.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_4_7_0)) {
            out.writeOptionalBoolean(this.ignoreNulls);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WindowFunction that = (WindowFunction)o;
        return Objects.equals(this.ignoreNulls, that.ignoreNulls) && this.windowDefinition.equals(that.windowDefinition);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.windowDefinition.hashCode();
        result = 31 * result + (this.ignoreNulls == null ? 0 : this.ignoreNulls.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return this.toString(Style.UNQUALIFIED);
    }

    @Override
    public String toString(Style style) {
        WindowFrameDefinition frameDefinition;
        OrderBy orderBy;
        StringBuilder builder = new StringBuilder(super.toString(style));
        if (this.ignoreNulls != null) {
            if (this.ignoreNulls.booleanValue()) {
                builder.append(" IGNORE NULLS");
            } else {
                builder.append(" RESPECT NULLS");
            }
        }
        builder.append(" OVER (");
        List<Symbol> partitions = this.windowDefinition.partitions();
        if (!partitions.isEmpty()) {
            builder.append("PARTITION BY ");
            builder.append(Lists.joinOn((String)", ", partitions, x -> x.toString(style)));
        }
        if ((orderBy = this.windowDefinition.orderBy()) != null) {
            if (!partitions.isEmpty()) {
                builder.append(" ");
            }
            builder.append("ORDER BY ");
            OrderBy.explainRepresentation(builder, orderBy.orderBySymbols(), orderBy.reverseFlags(), orderBy.nullsFirst(), x -> x.toString(style));
        }
        if ((frameDefinition = this.windowDefinition.windowFrameDefinition()) != WindowDefinition.RANGE_UNBOUNDED_PRECEDING_CURRENT_ROW) {
            builder.append(" ");
            builder.append(frameDefinition.mode().name());
            builder.append(" BETWEEN ");
            this.appendFrameBound(builder, style, frameDefinition.start());
            builder.append(" AND ");
            this.appendFrameBound(builder, style, frameDefinition.end());
        }
        builder.append(")");
        return builder.toString();
    }

    private void appendFrameBound(StringBuilder builder, Style style, FrameBoundDefinition frameBound) {
        switch (frameBound.type()) {
            case UNBOUNDED_PRECEDING: {
                builder.append("UNBOUNDED PRECEDING");
                break;
            }
            case PRECEDING: {
                builder.append(frameBound.value().toString(style));
                builder.append(" PRECEDING");
                break;
            }
            case CURRENT_ROW: {
                builder.append("CURRENT ROW");
                break;
            }
            case FOLLOWING: {
                builder.append(frameBound.value().toString(style));
                builder.append("FOLLOWING");
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                builder.append("UNBOUNDED FOLLOWING");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected frame bound type: " + String.valueOf(frameBound.type())));
            }
        }
    }
}

