/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.sql.Identifiers;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public final class PgGetKeywordsFunction
extends TableFunctionImplementation<List<Object>> {
    private static final String NAME = "pg_get_keywords";
    private static final FunctionName FUNCTION_NAME = new FunctionName("pg_catalog", "pg_get_keywords");
    private static final RowType RETURN_TYPE = new RowType(List.of(DataTypes.STRING, DataTypes.STRING, DataTypes.STRING), List.of("word", "catcode", "catdesc"));

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(FUNCTION_NAME, FunctionType.TABLE).argumentTypes(new TypeSignature[0]).returnType(RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), PgGetKeywordsFunction::new);
    }

    public PgGetKeywordsFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>>[] args) {
        return () -> Identifiers.KEYWORDS.stream().map(new Function<Identifiers.Keyword, Row>(this){
            final Object[] columns = new Object[3];
            final RowN row = new RowN(this.columns);

            @Override
            public Row apply(Identifiers.Keyword keyword) {
                this.columns[0] = keyword.word().toLowerCase(Locale.ENGLISH);
                if (keyword.reserved()) {
                    this.columns[1] = "R";
                    this.columns[2] = "reserved";
                } else {
                    this.columns[1] = "U";
                    this.columns[2] = "unreserved";
                }
                return this.row;
            }
        }).iterator();
    }

    @Override
    public RowType returnType() {
        return RETURN_TYPE;
    }

    @Override
    public boolean hasLazyResultSet() {
        return false;
    }
}

