/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Row;
import io.crate.data.RowN;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class RangeIterable<T>
implements Iterable<Row> {
    private final Object[] columns = new Object[]{null};
    private final RowN row = new RowN(this.columns);
    private final T endInclusive;
    private final UnaryOperator<T> nextValue;
    private final Comparator<T> comparator;
    private final Function<T, Object> resultExtractor;
    private final boolean reversed;
    private T value;

    public RangeIterable(T startInclusive, T endInclusive, UnaryOperator<T> nextValue, Comparator<T> comparator, Function<T, Object> valueExtractor) {
        this.value = startInclusive;
        this.endInclusive = endInclusive;
        this.nextValue = nextValue;
        this.comparator = comparator;
        this.resultExtractor = valueExtractor;
        this.reversed = comparator.compare(startInclusive, endInclusive) > 0;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                int cmp = RangeIterable.this.comparator.compare(RangeIterable.this.value, RangeIterable.this.endInclusive);
                return RangeIterable.this.reversed ? cmp >= 0 : cmp <= 0;
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more rows");
                }
                RangeIterable.this.columns[0] = RangeIterable.this.resultExtractor.apply(RangeIterable.this.value);
                RangeIterable.this.value = RangeIterable.this.nextValue.apply(RangeIterable.this.value);
                return RangeIterable.this.row;
            }
        };
    }
}

