/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.udf;

import io.crate.expression.udf.DropUserDefinedFunctionRequest;
import io.crate.expression.udf.UserDefinedFunctionService;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDropUserDefinedFunction
extends TransportMasterNodeAction<DropUserDefinedFunctionRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final UserDefinedFunctionService udfService;

    @Inject
    public TransportDropUserDefinedFunction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, UserDefinedFunctionService udfService) {
        super(ACTION.name(), transportService, clusterService, threadPool, DropUserDefinedFunctionRequest::new);
        this.udfService = udfService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(DropUserDefinedFunctionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.udfService.dropFunction(request.schema(), request.name(), request.argumentTypes(), request.ifExists(), listener, request.masterNodeTimeout());
    }

    @Override
    protected ClusterBlockException checkBlock(DropUserDefinedFunctionRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/udf/drop";

        private Action() {
            super(NAME);
        }
    }
}

