/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.udf;

import io.crate.common.collections.Lists;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.UserDefinedFunctionAlreadyExistsException;
import io.crate.exceptions.UserDefinedFunctionUnknownException;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.udf.UDFLanguage;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionProvider;
import io.crate.metadata.FunctionType;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.script.ScriptException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class UserDefinedFunctionService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(UserDefinedFunctionService.class);
    private final ClusterService clusterService;
    private final NodeContext nodeCtx;
    private final Map<String, UDFLanguage> languageRegistry = new HashMap<String, UDFLanguage>();

    public UserDefinedFunctionService(ClusterService clusterService, NodeContext nodeCtx) {
        this.clusterService = clusterService;
        this.nodeCtx = nodeCtx;
    }

    public UDFLanguage getLanguage(String languageName) throws IllegalArgumentException {
        UDFLanguage lang = this.languageRegistry.get(languageName);
        if (lang == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "'%s' is not a valid UDF language", languageName));
        }
        return lang;
    }

    public void registerLanguage(UDFLanguage language) {
        this.languageRegistry.put(language.name(), language);
    }

    void registerFunction(final UserDefinedFunctionMetadata metadata, final boolean replace, final ActionListener<AcknowledgedResponse> listener, final TimeValue timeout) {
        this.clusterService.submitStateUpdateTask("put_udf [" + metadata.name() + "]", new ClusterStateUpdateTask(this){
            final /* synthetic */ UserDefinedFunctionService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                UserDefinedFunctionsMetadata functions = this.this$0.putFunction((UserDefinedFunctionsMetadata)currentMetadata.custom("user_defined_functions"), metadata, replace);
                mdBuilder.putCustom("user_defined_functions", functions);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public TimeValue timeout() {
                return timeout;
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }
        });
    }

    void dropFunction(final String schema, final String name, final List<DataType<?>> argumentTypes, final boolean ifExists, final ActionListener<AcknowledgedResponse> listener, final TimeValue timeout) {
        this.clusterService.submitStateUpdateTask("drop_udf [" + schema + "." + name + " - " + String.valueOf(argumentTypes) + "]", new ClusterStateUpdateTask(this){
            final /* synthetic */ UserDefinedFunctionService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                this.this$0.ensureFunctionIsUnused(schema, name, argumentTypes);
                UserDefinedFunctionsMetadata functions = this.this$0.removeFunction((UserDefinedFunctionsMetadata)metadata.custom("user_defined_functions"), schema, name, argumentTypes, ifExists);
                mdBuilder.putCustom("user_defined_functions", functions);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public TimeValue timeout() {
                return timeout;
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @VisibleForTesting
    UserDefinedFunctionsMetadata putFunction(@Nullable UserDefinedFunctionsMetadata oldMetadata, UserDefinedFunctionMetadata functionMetadata, boolean replace) {
        if (oldMetadata == null) {
            return UserDefinedFunctionsMetadata.of(functionMetadata);
        }
        UserDefinedFunctionsMetadata newMetadata = UserDefinedFunctionsMetadata.newInstance(oldMetadata);
        if (oldMetadata.contains(functionMetadata.schema(), functionMetadata.name(), functionMetadata.argumentTypes())) {
            if (!replace) {
                throw new UserDefinedFunctionAlreadyExistsException(functionMetadata);
            }
            newMetadata.replace(functionMetadata);
        } else {
            newMetadata.add(functionMetadata);
        }
        assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
        return newMetadata;
    }

    @VisibleForTesting
    UserDefinedFunctionsMetadata removeFunction(@Nullable UserDefinedFunctionsMetadata functions, String schema, String name, List<DataType<?>> argumentDataTypes, boolean ifExists) {
        if (!(ifExists || functions != null && functions.contains(schema, name, argumentDataTypes))) {
            throw new UserDefinedFunctionUnknownException(schema, name, argumentDataTypes);
        }
        if (functions == null) {
            return UserDefinedFunctionsMetadata.of(new UserDefinedFunctionMetadata[0]);
        }
        UserDefinedFunctionsMetadata newMetadata = UserDefinedFunctionsMetadata.newInstance(functions);
        newMetadata.remove(schema, name, argumentDataTypes);
        return newMetadata;
    }

    public void updateImplementations(List<UserDefinedFunctionMetadata> userDefinedFunctions) {
        HashMap<FunctionName, List<FunctionProvider>> implementations = new HashMap<FunctionName, List<FunctionProvider>>();
        for (UserDefinedFunctionMetadata functionMetadata : userDefinedFunctions) {
            FunctionProvider provider = this.buildFunctionResolver(functionMetadata);
            if (provider == null) continue;
            FunctionName name = provider.signature().getName();
            List providers = implementations.computeIfAbsent(name, k -> new ArrayList());
            providers.add(provider);
        }
        this.nodeCtx.functions().setUDFs(implementations);
    }

    @Nullable
    public FunctionProvider buildFunctionResolver(UserDefinedFunctionMetadata udf) {
        Scalar<?, ?> scalar;
        FunctionName functionName = new FunctionName(udf.schema(), udf.name());
        Signature signature = Signature.builder(functionName, FunctionType.SCALAR).argumentTypes(Lists.map(udf.argumentTypes(), DataType::getTypeSignature)).returnType(udf.returnType().getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build();
        try {
            UDFLanguage language = this.getLanguage(udf.language());
            scalar = language.createFunctionImplementation(udf, signature, new BoundSignature(udf.argumentTypes(), udf.returnType()));
        }
        catch (IllegalArgumentException | ScriptException e) {
            LOGGER.warn("Can't create user defined function: " + udf.specificName(), (Throwable)e);
            return null;
        }
        return new FunctionProvider(signature, (s, args) -> scalar);
    }

    void ensureFunctionIsUnused(String schema, String functionName, List<DataType<?>> argTypes) {
        Schemas schemas = this.nodeCtx.schemas();
        FunctionName name = new FunctionName(schema, functionName);
        Predicate<Symbol> isFunction = s -> {
            Function fn;
            return s instanceof Function && (fn = (Function)s).signature().getName().equals(name) && fn.signature().getArgumentDataTypes().equals(argTypes);
        };
        for (SchemaInfo schemaInfo : schemas) {
            for (TableInfo tableInfo : schemaInfo.getTables()) {
                if (!(tableInfo instanceof DocTableInfo)) continue;
                DocTableInfo docTable = (DocTableInfo)tableInfo;
                List<GeneratedReference> generatedColumns = docTable.generatedColumns();
                for (GeneratedReference genColumn : generatedColumns) {
                    if (!genColumn.generatedExpression().any(isFunction)) continue;
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot drop function '%s'. It is in use by column '%s' of table '%s'", name.displayName(), genColumn.column(), docTable.ident()));
                }
            }
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.changedCustomMetadataSet().contains("user_defined_functions")) {
            Metadata newMetadata = event.state().metadata();
            UserDefinedFunctionsMetadata udfMetadata = (UserDefinedFunctionsMetadata)newMetadata.custom("user_defined_functions");
            this.updateImplementations(udfMetadata == null ? List.of() : udfMetadata.functionsMetadata());
        }
    }

    @Override
    protected void doStart() {
        this.clusterService.addListener(this);
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() throws IOException {
    }
}

