/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class CreateUserMappingRequest
extends AcknowledgedRequest<CreateUserMappingRequest> {
    private final boolean ifNotExists;
    private final String userName;
    private final String server;
    private final Settings options;

    public CreateUserMappingRequest(boolean ifNotExists, String userName, String server, Settings options) {
        this.ifNotExists = ifNotExists;
        this.userName = userName;
        this.server = server;
        this.options = options;
    }

    public CreateUserMappingRequest(StreamInput in) throws IOException {
        this.ifNotExists = in.readBoolean();
        this.userName = in.readString();
        this.server = in.readString();
        this.options = Settings.readSettingsFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.ifNotExists);
        out.writeString(this.userName);
        out.writeString(this.server);
        Settings.writeSettingsToStream(out, this.options);
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public String userName() {
        return this.userName;
    }

    public String server() {
        return this.server;
    }

    public Settings options() {
        return this.options;
    }
}

