/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.DropUserMappingRequest;
import io.crate.fdw.ServersMetadata;
import java.util.Locale;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;

public class DropUserMappingTask
extends AckedClusterStateUpdateTask<AcknowledgedResponse> {
    private final DropUserMappingRequest request;

    DropUserMappingTask(DropUserMappingRequest request) {
        super(Priority.NORMAL, request);
        this.request = request;
    }

    @Override
    protected AcknowledgedResponse newResponse(boolean acknowledged) {
        return new AcknowledgedResponse(acknowledged);
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        Metadata metadata = currentState.metadata();
        ServersMetadata servers = (ServersMetadata)metadata.custom("servers");
        if (servers == null) {
            throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Server `%s` not found", this.request.server()), new Object[0]);
        }
        ServersMetadata updatedServers = servers.dropUser(this.request.server(), this.request.userName(), this.request.ifExists());
        if (servers == updatedServers) {
            return currentState;
        }
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("servers", updatedServers)).build();
    }
}

