/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.AlterServerRequest;
import io.crate.fdw.AlterServerTask;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportAlterServer
extends TransportMasterNodeAction<AlterServerRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();

    @Inject
    public TransportAlterServer(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, AlterServerRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(AlterServerRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (state.nodes().getMinNodeVersion().before(Version.V_5_7_0)) {
            throw new IllegalStateException("Cannot execute ALTER SERVER while there are <5.7.0 nodes in the cluster");
        }
        AlterServerTask updateTask = new AlterServerTask(request);
        updateTask.completionFuture().whenComplete(listener);
        this.clusterService.submitStateUpdateTask("alter_server", updateTask);
    }

    @Override
    protected ClusterBlockException checkBlock(AlterServerRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/fdw/server/alter";

        private Action() {
            super(NAME);
        }
    }
}

