/*
 * Decompiled with CFR 0.152.
 */
package io.crate.ffi;

import io.crate.common.exceptions.Exceptions;
import io.crate.ffi.NativeError;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;

public class Natives {
    private static final Logger LOGGER = LogManager.getLogger(Natives.class);
    private static final Linker LINKER = Linker.nativeLinker();
    private static final SymbolLookup LOOKUP = LINKER.defaultLookup();
    private static final Linker.Option CCS = Linker.Option.captureCallState("errno");
    private static final StructLayout CAPTURE_STATE_LAYOUT = Linker.Option.captureStateLayout();
    private static final VarHandle ERRNO_HANDLE = CAPTURE_STATE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("errno"));
    private static final int ENOMEM = 12;
    private static boolean LOCAL_MLOCKALL = false;

    public static void tryMlockall() {
        int errno = Integer.MIN_VALUE;
        boolean rlimitSuccess = false;
        long softLimit = 0L;
        long hardLimit = 0L;
        try {
            Mmanh.mlockall(1);
            LOCAL_MLOCKALL = true;
        }
        catch (NativeError err) {
            LOGGER.warn("Unable to lock JVM Memory: error={}, reason={}", (Object)err.errno(), (Object)err.getMessage());
            LOGGER.warn("This can result in part of the JVM being swapped out.");
            errno = err.errno();
        }
        if (Constants.LINUX || Constants.MAC_OS_X) {
            try {
                RLimit rlimit = Rlimits.getrlimit(Rlimits.MEMLOCK);
                rlimitSuccess = true;
                softLimit = rlimit.cur();
                hardLimit = rlimit.max();
            }
            catch (NativeError err) {
                LOGGER.warn("Unable to retrieve resource limits: errno={} msg={}", (Object)err.errno(), (Object)err.getMessage());
            }
        }
        if (errno == 12) {
            if (rlimitSuccess) {
                LOGGER.warn("Increase RLIMIT_MEMLOCK, soft limit: {}, hard limit: {}", (Object)Natives.rlimitToString(softLimit), (Object)Natives.rlimitToString(hardLimit));
                if (Constants.LINUX) {
                    String user = System.getProperty("user.name");
                    LOGGER.warn("These can be adjusted by modifying /etc/security/limits.conf, for example: \n\t# allow user '{}' mlockall\n\t{} soft memlock unlimited\n\t{} hard memlock unlimited", (Object)user, (Object)user, (Object)user);
                    LOGGER.warn("If you are logged in interactively, you will have to re-login for the new limits to take effect.");
                }
            } else {
                LOGGER.warn("Increase RLIMIT_MEMLOCK (ulimit).");
            }
        }
    }

    private static String rlimitToString(long value) {
        assert (Constants.LINUX || Constants.MAC_OS_X);
        return value == Rlimits.INFINITY ? "unlimited" : Long.toUnsignedString(value);
    }

    public static long getMaxNumberOfThreads() {
        if (Constants.LINUX) {
            return Rlimits.getrlimit(6).cur();
        }
        return -1L;
    }

    private static long getCurRlimit(int resource) {
        if (Constants.LINUX || Constants.MAC_OS_X) {
            return Rlimits.getrlimit(resource).cur();
        }
        return -1L;
    }

    public static long getMaxSizeVirtualMemory() {
        return Natives.getCurRlimit(Rlimits.AS);
    }

    public static long getMaxFileSize() {
        return Natives.getCurRlimit(1);
    }

    public static boolean definitelyRunningAsRoot() {
        if (Constants.WINDOWS) {
            return false;
        }
        try {
            return Unistdh.geteuid() == 0;
        }
        catch (RuntimeException t) {
            return false;
        }
    }

    public static boolean isMemoryLocked() {
        return LOCAL_MLOCKALL;
    }

    private static class Mmanh {
        static final int MCL_CURRENT = 1;
        private static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
        private static final MemorySegment ADDR = LOOKUP.find("mlockall").orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: strerror"));
        private static final MethodHandle HANDLE = LINKER.downcallHandle(ADDR, DESC, CCS);

        private Mmanh() {
        }

        public static int mlockall(int flags) {
            Arena arena = Arena.ofConfined();
            try {
                MemorySegment captureState = arena.allocate(CAPTURE_STATE_LAYOUT);
                int result = HANDLE.invokeExact(captureState, flags);
                if (result == -1) {
                    int errno = ERRNO_HANDLE.get(captureState, 0);
                    throw new NativeError(errno, Stringh.strerror(errno));
                }
                int n = result;
                if (arena != null) {
                    arena.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                try {
                    if (arena != null) {
                        try {
                            arena.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw Exceptions.toRuntimeException((Throwable)t);
                }
            }
        }
    }

    public static class Rlimits {
        public static final int NPROC = 6;
        public static final int MEMLOCK = Constants.MAC_OS_X ? 6 : 8;
        public static final int AS = Constants.MAC_OS_X ? 5 : 9;
        public static final int FSIZE = 1;
        public static final long INFINITY = Constants.MAC_OS_X ? Long.MAX_VALUE : -1L;
        private static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
        private static final MemorySegment ADDR = LOOKUP.find("getrlimit").orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: getrlimit"));
        private static final MethodHandle HANDLE = LINKER.downcallHandle(ADDR, DESC, CCS);
        private static final StructLayout LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_LONG.withName("rlim_cur"), ValueLayout.JAVA_LONG.withName("rlim_max")).withName("rlimit");

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static RLimit getrlimit(int resource) {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment rlimit = arena.allocate(LAYOUT);
                MemorySegment captureState = arena.allocate(CAPTURE_STATE_LAYOUT);
                int ret = HANDLE.invokeExact(captureState, resource, rlimit);
                if (ret == 0) {
                    long cur = rlimit.getAtIndex(ValueLayout.JAVA_LONG, 0L);
                    long max = rlimit.getAtIndex(ValueLayout.JAVA_LONG, 1L);
                    RLimit rLimit = new RLimit(cur, max);
                    return rLimit;
                }
                int errno = ERRNO_HANDLE.get(captureState, 0);
                throw new NativeError(errno, Stringh.strerror(errno));
            }
            catch (Throwable t) {
                throw Exceptions.toRuntimeException((Throwable)t);
            }
        }
    }

    record RLimit(long cur, long max) {
    }

    private static class Unistdh {
        private static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]);
        private static final MemorySegment ADDR = LOOKUP.find("geteuid").orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: geteuid"));
        private static final MethodHandle HANDLE = LINKER.downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private Unistdh() {
        }

        public static int geteuid() {
            try {
                int result = HANDLE.invokeExact();
                return result;
            }
            catch (Throwable t) {
                throw Exceptions.toRuntimeException((Throwable)t);
            }
        }
    }

    private static class Stringh {
        private static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.JAVA_INT);
        private static final MemorySegment ADDR = LOOKUP.find("strerror").orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: strerror"));
        private static final MethodHandle HANDLE = LINKER.downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private Stringh() {
        }

        public static String strerror(int errno) {
            try {
                MemorySegment ptr = HANDLE.invokeExact(errno);
                return ptr.reinterpret(Long.MAX_VALUE).getString(0L);
            }
            catch (Throwable t) {
                throw Exceptions.toRuntimeException((Throwable)t);
            }
        }
    }
}

