/*
 * Decompiled with CFR 0.152.
 */
package io.crate.geo;

import io.crate.types.GeoPointType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;

public class GeoJSONUtils {
    public static final String COORDINATES_FIELD = "coordinates";
    public static final String TYPE_FIELD = "type";
    static final String GEOMETRIES_FIELD = "geometries";
    public static final String GEOMETRY_COLLECTION = "GeometryCollection";
    public static final String POINT = "Point";
    private static final String MULTI_POINT = "MultiPoint";
    public static final String LINE_STRING = "LineString";
    private static final String MULTI_LINE_STRING = "MultiLineString";
    public static final String POLYGON = "Polygon";
    private static final String MULTI_POLYGON = "MultiPolygon";
    public static final Map<String, String> COMPOSABLE_TYPES = Map.of("Point", "MultiPoint", "Polygon", "MultiPolygon", "LineString", "MultiLineString");
    private static final Map<String, String> GEOJSON_TYPES = Map.ofEntries(Map.entry("GeometryCollection", "GeometryCollection"), Map.entry("GeometryCollection".toLowerCase(Locale.ENGLISH), "GeometryCollection"), Map.entry("Point", "Point"), Map.entry("Point".toLowerCase(Locale.ENGLISH), "Point"), Map.entry("MultiPoint", "MultiPoint"), Map.entry("MultiPoint".toLowerCase(Locale.ENGLISH), "MultiPoint"), Map.entry("LineString", "LineString"), Map.entry("LineString".toLowerCase(Locale.ENGLISH), "LineString"), Map.entry("MultiLineString", "MultiLineString"), Map.entry("MultiLineString".toLowerCase(Locale.ENGLISH), "MultiLineString"), Map.entry("Polygon", "Polygon"), Map.entry("Polygon".toLowerCase(Locale.ENGLISH), "Polygon"), Map.entry("MultiPolygon", "MultiPolygon"), Map.entry("MultiPolygon".toLowerCase(Locale.ENGLISH), "MultiPolygon"));
    private static final GeoJSONMapConverter GEOJSON_CONVERTER = new GeoJSONMapConverter();

    private static void forEach(Object arrayOrCollection, Consumer<Object> consumer) {
        if (arrayOrCollection.getClass().isArray()) {
            int arrayLength = Array.getLength(arrayOrCollection);
            for (int i = 0; i < arrayLength; ++i) {
                Object elem = Array.get(arrayOrCollection, i);
                consumer.accept(elem);
            }
        } else if (arrayOrCollection instanceof Collection) {
            Collection collection = (Collection)arrayOrCollection;
            collection.forEach(consumer);
        } else {
            throw new AssertionError((Object)"argument is neither an array nor a collection");
        }
    }

    public static Map<String, Object> shape2Map(Shape shape) {
        if (shape instanceof ShapeCollection) {
            ShapeCollection shapeCollection = (ShapeCollection)shape;
            ArrayList<Map<String, Object>> geometries = new ArrayList<Map<String, Object>>(shapeCollection.size());
            for (Shape collShape : shapeCollection) {
                geometries.add(GeoJSONUtils.shape2Map(collShape));
            }
            return Map.of(TYPE_FIELD, GEOMETRY_COLLECTION, GEOMETRIES_FIELD, geometries);
        }
        try {
            return GEOJSON_CONVERTER.convert(JtsSpatialContext.GEO.getShapeFactory().getGeometryFrom(shape));
        }
        catch (InvalidShapeException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot convert shape %s to Map", shape), e);
        }
    }

    public static Shape wkt2Shape(String wkt) {
        try {
            return GeoPointType.WKT_READER.parse(wkt);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot convert WKT \"%s\" to shape", wkt), e);
        }
    }

    public static Map<String, Object> wkt2Map(String wkt) {
        return GeoJSONUtils.shape2Map(GeoJSONUtils.wkt2Shape(wkt));
    }

    public static Shape map2Shape(Map<String, Object> geoJSONMap) {
        return GeoJSONUtils.geoJSONString2ShapeBuilder(geoJSONMap).buildS4J();
    }

    public static Object map2LuceneShape(Map<String, Object> geoJSONMap) {
        return GeoJSONUtils.geoJSONString2ShapeBuilder(geoJSONMap).buildLucene();
    }

    public static int compare(Map<String, Object> val1, Map<String, Object> val2) {
        Object type1 = val1.get(TYPE_FIELD);
        Object type2 = val2.get(TYPE_FIELD);
        assert (type1 != null && type2 != null) : "Shapes must be valid";
        if (!type1.equals(type2)) {
            return 1;
        }
        int result = 0;
        if (GEOMETRY_COLLECTION.equals(type1)) {
            Object geometries1 = val1.get(GEOMETRIES_FIELD);
            Object geometries2 = val2.get(GEOMETRIES_FIELD);
            assert (geometries1 instanceof Collection) : " Geometries must be a collection";
            assert (geometries2 instanceof Collection) : " Geometries must be a collection";
            Collection geoms1 = (Collection)geometries1;
            Collection geoms2 = (Collection)geometries2;
            if (geoms1.size() != geoms2.size()) {
                return 1;
            }
            Iterator it1 = geoms1.iterator();
            Iterator it2 = geoms2.iterator();
            while (it1.hasNext()) {
                Object value1 = it1.next();
                Object value2 = it2.next();
                assert (value1 instanceof Map) : "Shapes must be valid";
                assert (value2 instanceof Map) : "Shapes must be valid";
                if (GeoJSONUtils.compare((Map)value1, (Map)value2) == 0) continue;
                result = 1;
                break;
            }
        } else {
            Shape shape2;
            Shape shape1 = GeoJSONUtils.map2Shape(val1);
            if (!shape1.equals((Object)(shape2 = GeoJSONUtils.map2Shape(val2))) && shape1.relate(shape2) != shape2.relate(shape1)) {
                result = 1;
            }
        }
        return result;
    }

    private static ShapeBuilder geoJSONString2ShapeBuilder(Map<String, Object> geoJSONMap) {
        String geoJSON;
        try {
            geoJSON = Strings.toString(JsonXContent.builder().map(geoJSONMap));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot convert Map \"%s\" to shape", geoJSONMap), e);
        }
        try {
            XContentParser parser = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, geoJSON);
            parser.nextToken();
            return ShapeParser.parse(parser);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot convert GeoJSON \"%s\" to shape", geoJSON), t);
        }
    }

    public static Map<String, Object> sanitizeMap(Map<?, ?> value) {
        String type = BytesRefs.toString(value.get(TYPE_FIELD));
        if (type == null) {
            throw new IllegalArgumentException(GeoJSONUtils.invalidGeoJSON("type field missing"));
        }
        if ((type = GEOJSON_TYPES.get(type)) == null) {
            throw new IllegalArgumentException(GeoJSONUtils.invalidGeoJSON("invalid type"));
        }
        if (GEOMETRY_COLLECTION.equals(type)) {
            Object geometries = value.get(GEOMETRIES_FIELD);
            if (geometries == null) {
                throw new IllegalArgumentException(GeoJSONUtils.invalidGeoJSON("geometries field missing"));
            }
            String[] typeInCollection = new String[]{null};
            boolean[] sameType = new boolean[]{true};
            ArrayList sanitizedGeometries = new ArrayList();
            GeoJSONUtils.forEach(geometries, input -> {
                if (!(input instanceof Map)) {
                    throw new IllegalArgumentException(GeoJSONUtils.invalidGeoJSON("invalid GeometryCollection"));
                }
                Map map = (Map)input;
                Map<String, Object> sanitizedShape = GeoJSONUtils.sanitizeMap(map);
                sanitizedGeometries.add(sanitizedShape);
                String shapeType = BytesRefs.toString(sanitizedShape.get(TYPE_FIELD));
                if (typeInCollection[0] == null) {
                    typeInCollection[0] = shapeType;
                } else if (!typeInCollection[0].equals(shapeType)) {
                    sameType[0] = false;
                }
            });
            HashMap<String, Object> transformed = new HashMap<String, Object>();
            String targetType = COMPOSABLE_TYPES.get(typeInCollection[0]);
            if (sameType[0] && targetType != null) {
                transformed.put(TYPE_FIELD, targetType);
                ArrayList coords = new ArrayList();
                GeoJSONUtils.forEach(geometries, input -> {
                    Map validatedShape = (Map)input;
                    coords.add(validatedShape.get(COORDINATES_FIELD));
                });
                transformed.put(COORDINATES_FIELD, coords);
            } else {
                transformed.put(TYPE_FIELD, GEOMETRY_COLLECTION);
                transformed.put(GEOMETRIES_FIELD, sanitizedGeometries);
            }
            return transformed;
        }
        Object coordinates = value.get(COORDINATES_FIELD);
        if (coordinates == null) {
            throw new IllegalArgumentException(GeoJSONUtils.invalidGeoJSON("coordinates field missing"));
        }
        switch (type) {
            case "Point": {
                GeoJSONUtils.validateCoordinate(coordinates);
                break;
            }
            case "MultiPoint": 
            case "LineString": {
                GeoJSONUtils.validateCoordinates(coordinates, 1);
                break;
            }
            case "Polygon": 
            case "MultiLineString": {
                GeoJSONUtils.validateCoordinates(coordinates, 2);
                break;
            }
            case "MultiPolygon": {
                GeoJSONUtils.validateCoordinates(coordinates, 3);
                break;
            }
            default: {
                throw new IllegalArgumentException(GeoJSONUtils.invalidGeoJSON("invalid type"));
            }
        }
        return value;
    }

    private static void validateCoordinates(Object coordinates, int depth) {
        GeoJSONUtils.forEach(coordinates, input -> {
            if (depth > 1) {
                GeoJSONUtils.validateCoordinates(input, depth - 1);
            } else {
                GeoJSONUtils.validateCoordinate(input);
            }
        });
    }

    private static void validateCoordinate(Object coordinate) {
        try {
            double y;
            double x;
            if (coordinate.getClass().isArray()) {
                assert (Array.getLength(coordinate) == 2) : GeoJSONUtils.invalidGeoJSON("invalid coordinate");
                x = ((Number)Array.get(coordinate, 0)).doubleValue();
                y = ((Number)Array.get(coordinate, 1)).doubleValue();
            } else if (coordinate instanceof Collection) {
                assert (((Collection)coordinate).size() == 2) : GeoJSONUtils.invalidGeoJSON("invalid coordinate");
                Iterator iter = ((Collection)coordinate).iterator();
                x = ((Number)iter.next()).doubleValue();
                y = ((Number)iter.next()).doubleValue();
            } else {
                throw new IllegalArgumentException(GeoJSONUtils.invalidGeoJSON("invalid coordinate"));
            }
            JtsSpatialContext.GEO.getShapeFactory().verifyX(x);
            JtsSpatialContext.GEO.getShapeFactory().verifyY(y);
        }
        catch (ClassCastException | InvalidShapeException e) {
            throw new IllegalArgumentException(GeoJSONUtils.invalidGeoJSON("invalid coordinate"), e);
        }
    }

    private static String invalidGeoJSON(String message) {
        return String.format(Locale.ENGLISH, "Invalid GeoJSON: %s", message);
    }

    private static class GeoJSONMapConverter {
        private GeoJSONMapConverter() {
        }

        public Map<String, Object> convert(Geometry geometry) {
            HashMap<String, Object> builder = new HashMap<String, Object>();
            if (geometry instanceof Point) {
                builder.put(GeoJSONUtils.TYPE_FIELD, GeoJSONUtils.POINT);
                builder.put(GeoJSONUtils.COORDINATES_FIELD, this.extract((Point)geometry));
            } else if (geometry instanceof MultiPoint) {
                builder.put(GeoJSONUtils.TYPE_FIELD, GeoJSONUtils.MULTI_POINT);
                builder.put(GeoJSONUtils.COORDINATES_FIELD, this.extract((MultiPoint)geometry));
            } else if (geometry instanceof LineString) {
                builder.put(GeoJSONUtils.TYPE_FIELD, GeoJSONUtils.LINE_STRING);
                builder.put(GeoJSONUtils.COORDINATES_FIELD, this.extract((LineString)geometry));
            } else if (geometry instanceof MultiLineString) {
                builder.put(GeoJSONUtils.TYPE_FIELD, GeoJSONUtils.MULTI_LINE_STRING);
                builder.put(GeoJSONUtils.COORDINATES_FIELD, this.extract((MultiLineString)geometry));
            } else if (geometry instanceof Polygon) {
                builder.put(GeoJSONUtils.TYPE_FIELD, GeoJSONUtils.POLYGON);
                builder.put(GeoJSONUtils.COORDINATES_FIELD, this.extract((Polygon)geometry));
            } else if (geometry instanceof MultiPolygon) {
                builder.put(GeoJSONUtils.TYPE_FIELD, GeoJSONUtils.MULTI_POLYGON);
                builder.put(GeoJSONUtils.COORDINATES_FIELD, this.extract((MultiPolygon)geometry));
            } else if (geometry instanceof GeometryCollection) {
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                int size = geometryCollection.getNumGeometries();
                ArrayList<Map<String, Object>> geometries = new ArrayList<Map<String, Object>>(size);
                for (int i = 0; i < size; ++i) {
                    geometries.add(this.convert(geometryCollection.getGeometryN(i)));
                }
                builder.put(GeoJSONUtils.TYPE_FIELD, GeoJSONUtils.GEOMETRY_COLLECTION);
                builder.put(GeoJSONUtils.GEOMETRIES_FIELD, geometries);
            } else {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot extract coordinates from geometry %s", geometry.getGeometryType()));
            }
            return Collections.unmodifiableMap(builder);
        }

        private double[] extract(Point point) {
            return this.toArray(point.getCoordinate());
        }

        private double[][] extract(MultiPoint multiPoint) {
            return this.toArray(multiPoint.getCoordinates());
        }

        private double[][] extract(LineString lineString) {
            return this.toArray(lineString.getCoordinates());
        }

        private double[][][] extract(MultiLineString multiLineString) {
            int size = multiLineString.getNumGeometries();
            double[][][] lineStrings = new double[size][][];
            for (int i = 0; i < size; ++i) {
                lineStrings[i] = this.toArray(multiLineString.getGeometryN(i).getCoordinates());
            }
            return lineStrings;
        }

        private double[][][] extract(Polygon polygon) {
            int size = polygon.getNumInteriorRing() + 1;
            double[][][] rings = new double[size][][];
            rings[0] = this.toArray(polygon.getExteriorRing().getCoordinates());
            for (int i = 0; i < size - 1; ++i) {
                rings[i + 1] = this.toArray(polygon.getInteriorRingN(i).getCoordinates());
            }
            return rings;
        }

        private double[][][][] extract(MultiPolygon multiPolygon) {
            int size = multiPolygon.getNumGeometries();
            double[][][][] polygons = new double[size][][][];
            for (int i = 0; i < size; ++i) {
                polygons[i] = this.extract((Polygon)multiPolygon.getGeometryN(i));
            }
            return polygons;
        }

        double[] toArray(Coordinate coordinate) {
            return new double[]{coordinate.x, coordinate.y};
        }

        double[][] toArray(Coordinate[] coordinates) {
            double[][] array = new double[coordinates.length][];
            for (int i = 0; i < coordinates.length; ++i) {
                array[i] = this.toArray(coordinates[i]);
            }
            return array;
        }
    }
}

