/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene.codec;

import io.crate.lucene.codec.CustomLucene90DocValuesConsumer;
import io.crate.lucene.codec.CustomLucene90DocValuesProducer;
import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class CustomLucene90DocValuesFormat
extends DocValuesFormat {
    private final Mode mode;
    private final int skipIndexIntervalSize;
    static final String DATA_CODEC = "Lucene90DocValuesData";
    static final String DATA_EXTENSION = "dvd";
    static final String META_CODEC = "Lucene90DocValuesMetadata";
    static final String META_EXTENSION = "dvm";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final byte NUMERIC = 0;
    static final byte BINARY = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final byte SORTED_NUMERIC = 4;
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    static final int NUMERIC_BLOCK_SHIFT = 14;
    static final int NUMERIC_BLOCK_SIZE = 16384;
    static final int TERMS_DICT_BLOCK_SHIFT = 4;
    static final int TERMS_DICT_BLOCK_SIZE = 16;
    static final int TERMS_DICT_BLOCK_MASK = 15;
    static final int TERMS_DICT_BLOCK_COMPRESSION_THRESHOLD = 32;
    static final int TERMS_DICT_BLOCK_LZ4_SHIFT = 6;
    static final int TERMS_DICT_BLOCK_LZ4_SIZE = 64;
    static final int TERMS_DICT_BLOCK_LZ4_MASK = 63;
    static final int TERMS_DICT_REVERSE_INDEX_SHIFT = 10;
    static final int TERMS_DICT_REVERSE_INDEX_SIZE = 1024;
    static final int TERMS_DICT_REVERSE_INDEX_MASK = 1023;
    static final int TERMS_DICT_COMPRESSOR_LZ4_CODE = 1;
    static final int TERMS_DICT_BLOCK_LZ4_CODE = 393217;
    private static final int DEFAULT_SKIP_INDEX_INTERVAL_SIZE = 4096;
    private static final long SKIP_INDEX_INTERVAL_BYTES = 29L;
    static final int SKIP_INDEX_LEVEL_SHIFT = 3;
    static final int SKIP_INDEX_MAX_LEVEL = 4;
    static final long[] SKIP_INDEX_JUMP_LENGTH_PER_LEVEL = new long[4];

    public CustomLucene90DocValuesFormat() {
        this(Mode.BEST_SPEED, 4096);
    }

    public CustomLucene90DocValuesFormat(Mode mode) {
        this(mode, 4096);
    }

    public CustomLucene90DocValuesFormat(Mode mode, int skipIndexIntervalSize) {
        super("CrateDBLucene90");
        this.mode = mode;
        if (skipIndexIntervalSize < 2) {
            throw new IllegalArgumentException("skipIndexIntervalSize must be > 1, got [" + skipIndexIntervalSize + "]");
        }
        this.skipIndexIntervalSize = skipIndexIntervalSize;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new CustomLucene90DocValuesConsumer(state, this.skipIndexIntervalSize, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION, this.mode);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new CustomLucene90DocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    static {
        CustomLucene90DocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[0] = 24L;
        for (int level = 1; level < 4; ++level) {
            CustomLucene90DocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level - 1];
            int n = level;
            SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n] + (long)(1 << level * 3) * 29L;
            int n2 = level;
            SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n2] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n2] - (long)(1 << (level - 1) * 3);
        }
    }

    public static enum Mode {
        BEST_SPEED,
        BEST_COMPRESSION;

    }
}

