/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexReference;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.function.Predicate;

public final class DocReferences {
    private DocReferences() {
    }

    public static Symbol inverseSourceLookup(Symbol symbol) {
        return RefReplacer.replaceRefs(symbol, DocReferences::docRefToRegularRef);
    }

    public static Symbol toDocLookup(Symbol tree) {
        return RefReplacer.replaceRefs(tree, DocReferences::toDocLookup);
    }

    public static Symbol toDocLookup(Symbol tree, Predicate<Reference> condition) {
        return RefReplacer.replaceRefs(tree, r -> DocReferences.toDocLookup(r, condition));
    }

    public static Reference toDocLookup(Reference reference) {
        return DocReferences.toDocLookup(reference, (Reference r) -> true);
    }

    private static Reference toDocLookup(Reference reference, Predicate<Reference> condition) {
        ReferenceIdent ident = reference.ident();
        if (ident.columnIdent().isSystemColumn()) {
            return reference;
        }
        if (reference.granularity() == RowGranularity.DOC && Schemas.isDefaultOrCustomSchema(ident.tableIdent().schema()) && condition.test(reference)) {
            return reference.withReferenceIdent(new ReferenceIdent(ident.tableIdent(), ident.columnIdent().prepend("_doc")));
        }
        return reference;
    }

    public static Reference docRefToRegularRef(Reference ref) {
        ColumnIdent column = ref.column();
        if (!column.isRoot() && column.name().equals("_doc")) {
            return ref.withReferenceIdent(new ReferenceIdent(ref.ident().tableIdent(), column.shiftRight()));
        }
        return ref;
    }

    public static List<Reference> applyOid(Collection<Reference> sourceReferences, LongSupplier columnOidSupplier) {
        ArrayList<Reference> references = new ArrayList<Reference>(sourceReferences.size());
        HashMap<ColumnIdent, Reference> referencesMap = new HashMap<ColumnIdent, Reference>(sourceReferences.size());
        for (Reference ref : sourceReferences) {
            Reference newRef = ref.withOidAndPosition(columnOidSupplier, () -> ref.position());
            references.add(newRef);
            referencesMap.put(newRef.column(), newRef);
        }
        for (int i = 0; i < references.size(); ++i) {
            Reference ref;
            ref = (Reference)references.get(i);
            if (!(ref instanceof IndexReference)) continue;
            IndexReference indexReference = (IndexReference)ref;
            ArrayList<Reference> newSources = new ArrayList<Reference>(indexReference.columns().size());
            for (Reference sourceRef : indexReference.columns()) {
                newSources.add((Reference)referencesMap.get(sourceRef.column()));
            }
            references.set(i, indexReference.withColumns(newSources));
        }
        return references;
    }
}

