/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.exceptions.AnalyzerInvalidException;
import io.crate.exceptions.AnalyzerUnknownException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.analysis.AnalysisRegistry;

public class FulltextAnalyzerResolver {
    private final ClusterService clusterService;
    private final AnalysisRegistry analysisRegistry;
    private static final Set<String> EXTENDED_BUILTIN_TOKEN_FILTERS = Set.of("limit", "synonym", "keep", "pattern_capture", "pattern_replace", "dictionary_decompounder", "hyphenation_decompounder", "keyword_marker", "stemmer_override", "hunspell", "cjk_bigram", "cjk_width");
    private static final Set<String> EXTENDED_BUILTIN_CHAR_FILTERS = Set.of("mapping", "pattern_replace");
    public static final String SQL_STATEMENT_KEY = "_sql_stmt";

    @Inject
    public FulltextAnalyzerResolver(ClusterService clusterService, AnalysisRegistry analysisRegistry) {
        this.clusterService = clusterService;
        this.analysisRegistry = analysisRegistry;
    }

    public boolean hasAnalyzer(String name) {
        return this.hasBuiltInAnalyzer(name) || this.hasCustomAnalyzer(name);
    }

    public boolean hasBuiltInAnalyzer(String name) {
        try {
            return this.analysisRegistry.getAnalyzer(name) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Set<String> getBuiltInAnalyzers() {
        return Set.copyOf(this.analysisRegistry.getAnalyzers().keySet());
    }

    public Settings getCustomAnalyzer(String name) {
        return this.getCustomThingy(name, CustomType.ANALYZER);
    }

    public Map<String, Settings> getCustomAnalyzers() throws IOException {
        HashMap<String, Settings> result = new HashMap<String, Settings>();
        Settings analyzer = this.getCustomThingies(CustomType.ANALYZER);
        for (String settingName : analyzer.keySet()) {
            if (settingName.endsWith("._sql_stmt")) continue;
            result.put(settingName, FulltextAnalyzerResolver.decodeSettings(analyzer.get(settingName)));
        }
        return result;
    }

    public boolean hasCustomAnalyzer(String name) {
        return this.hasCustomThingy(name, CustomType.ANALYZER);
    }

    public boolean hasBuiltInTokenizer(String name) {
        return this.analysisRegistry.getTokenizerProvider(name) != null;
    }

    public Set<String> getBuiltInTokenizers() {
        return Set.copyOf(this.analysisRegistry.getTokenizers().keySet());
    }

    public Map<String, Settings> getCustomTokenizers() throws IOException {
        return FulltextAnalyzerResolver.getDecodedSettings(this.getCustomThingies(CustomType.TOKENIZER));
    }

    public boolean hasBuiltInCharFilter(String name) {
        return EXTENDED_BUILTIN_CHAR_FILTERS.contains(name) || this.analysisRegistry.getCharFilterProvider(name) != null;
    }

    public Set<String> getBuiltInCharFilters() {
        HashSet<String> charFilters = new HashSet<String>();
        charFilters.addAll(EXTENDED_BUILTIN_CHAR_FILTERS);
        charFilters.addAll(this.analysisRegistry.getCharFilters().keySet());
        return Collections.unmodifiableSet(charFilters);
    }

    public Map<String, Settings> getCustomCharFilters() throws IOException {
        return FulltextAnalyzerResolver.getDecodedSettings(this.getCustomThingies(CustomType.CHAR_FILTER));
    }

    public boolean hasBuiltInTokenFilter(String name) {
        return EXTENDED_BUILTIN_TOKEN_FILTERS.contains(name) || this.analysisRegistry.getTokenFilterProvider(name) != null;
    }

    public Set<String> getBuiltInTokenFilters() {
        HashSet<String> tokenFilters = new HashSet<String>();
        tokenFilters.addAll(EXTENDED_BUILTIN_TOKEN_FILTERS);
        tokenFilters.addAll(this.analysisRegistry.getTokenFilters().keySet());
        return Collections.unmodifiableSet(tokenFilters);
    }

    public Map<String, Settings> getCustomTokenFilters() throws IOException {
        return FulltextAnalyzerResolver.getDecodedSettings(this.getCustomThingies(CustomType.TOKEN_FILTER));
    }

    private static Map<String, Settings> getDecodedSettings(Settings settings) throws IOException {
        HashMap<String, Settings> result = new HashMap<String, Settings>();
        for (String name : settings.keySet()) {
            result.put(name, FulltextAnalyzerResolver.decodeSettings(settings.get(name)));
        }
        return result;
    }

    public static BytesReference encodeSettings(Settings settings) {
        try {
            XContentBuilder builder = JsonXContent.builder();
            builder.startObject();
            settings.toXContent(builder, false);
            builder.endObject();
            return BytesReference.bytes(builder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Settings decodeSettings(String encodedSettings) throws IOException {
        return Settings.builder().loadFromSource(encodedSettings, XContentType.JSON).build();
    }

    private Settings getCustomThingy(String name, CustomType type) {
        if (name == null) {
            return null;
        }
        String encodedSettings = this.clusterService.state().metadata().persistentSettings().get(type.buildSettingName(name));
        if (encodedSettings == null) {
            return null;
        }
        try {
            return FulltextAnalyzerResolver.decodeSettings(encodedSettings);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Settings getCustomThingies(CustomType type) {
        Map<String, Settings> settingsMap = this.clusterService.state().metadata().persistentSettings().getGroups("crate.analysis.custom.");
        Settings result = settingsMap.get(type.getName());
        return result != null ? result : Settings.EMPTY;
    }

    public boolean hasCustomThingy(String name, CustomType type) {
        return this.clusterService.state().metadata().persistentSettings().hasValue(type.buildSettingName(name));
    }

    public Settings resolveFullCustomAnalyzerSettings(String name) throws AnalyzerInvalidException {
        Settings.Builder builder = Settings.builder();
        Settings analyzerSettings = this.getCustomAnalyzer(name);
        if (analyzerSettings != null) {
            builder.put(analyzerSettings);
            String tokenizerName = analyzerSettings.get(CustomType.ANALYZER.buildSettingChildName(name, CustomType.TOKENIZER.getName()));
            if (tokenizerName != null) {
                Settings customTokenizerSettings = this.getCustomTokenizer(tokenizerName);
                if (customTokenizerSettings != null) {
                    builder.put(customTokenizerSettings);
                } else if (!this.hasBuiltInTokenizer(tokenizerName)) {
                    throw new AnalyzerInvalidException(String.format(Locale.ENGLISH, "Invalid Analyzer: could not resolve tokenizer '%s'", tokenizerName));
                }
            }
            List<String> tokenFilterNames = analyzerSettings.getAsList(CustomType.ANALYZER.buildSettingChildName(name, CustomType.TOKEN_FILTER.getName()));
            for (String tokenFilterName : tokenFilterNames) {
                Settings customTokenFilterSettings = this.getCustomTokenFilter(tokenFilterName);
                if (customTokenFilterSettings != null) {
                    builder.put(customTokenFilterSettings);
                    continue;
                }
                if (this.hasBuiltInTokenFilter(tokenFilterName)) continue;
                throw new AnalyzerInvalidException(String.format(Locale.ENGLISH, "Invalid Analyzer: could not resolve token-filter '%s'", tokenFilterName));
            }
            List<String> charFilterNames = analyzerSettings.getAsList(CustomType.ANALYZER.buildSettingChildName(name, CustomType.CHAR_FILTER.getName()));
            for (String charFilterName : charFilterNames) {
                Settings customCharFilterSettings = this.getCustomCharFilter(charFilterName);
                if (customCharFilterSettings != null) {
                    builder.put(customCharFilterSettings);
                    continue;
                }
                if (this.hasBuiltInCharFilter(charFilterName)) continue;
                throw new AnalyzerInvalidException(String.format(Locale.ENGLISH, "Invalid Analyzer: could not resolve char-filter '%s'", charFilterName));
            }
        } else {
            throw new AnalyzerUnknownException(name);
        }
        return builder.build();
    }

    public Settings getCustomTokenizer(String name) {
        return this.getCustomThingy(name, CustomType.TOKENIZER);
    }

    public Settings getCustomTokenFilter(String name) {
        return this.getCustomThingy(name, CustomType.TOKEN_FILTER);
    }

    public Settings getCustomCharFilter(String name) {
        return this.getCustomThingy(name, CustomType.CHAR_FILTER);
    }

    public static enum CustomType {
        ANALYZER("analyzer"),
        TOKENIZER("tokenizer"),
        TOKEN_FILTER("filter"),
        CHAR_FILTER("char_filter");

        private static final String INDEX_ANALYSIS_PREFIX = "index.analysis.";
        private final String name;
        private final String settingNamePrefix;
        private final String settingChildNamePrefix;

        private CustomType(String name) {
            this.name = name;
            this.settingNamePrefix = "crate.analysis.custom." + name + ".";
            this.settingChildNamePrefix = INDEX_ANALYSIS_PREFIX + name + ".";
        }

        public String getName() {
            return this.name;
        }

        public String buildSettingName(String customName) {
            return this.settingNamePrefix + customName;
        }

        public String buildSettingChildName(String customName, String settingName) {
            return this.buildSettingChildNamePrefix(customName) + "." + settingName;
        }

        public String buildSettingChildNamePrefix(String customName) {
            return this.settingChildNamePrefix + customName;
        }
    }
}

