/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.exceptions.PartitionUnknownException;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.sql.tree.Assignment;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.codec.binary.Base32;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartitionName
implements Writeable {
    private static final Base32 BASE32 = new Base32(true);
    private final RelationName relationName;
    @Nullable
    private List<String> values;
    @Nullable
    private String indexName;
    @Nullable
    private String ident;

    public static PartitionName ofAssignments(RelationName relation, List<Assignment<Object>> assignments) {
        String[] values = new String[assignments.size()];
        int idx = 0;
        for (Assignment<Object> o : assignments) {
            values[idx++] = DataTypes.STRING.implicitCast(o.expression());
        }
        return new PartitionName(relation, List.of(values));
    }

    public static PartitionName ofAssignments(DocTableInfo table, List<Assignment<Object>> assignments, Metadata metadata) {
        PartitionName partitionName = PartitionName.ofAssignmentsUnsafe(table, assignments);
        if (!table.getPartitionNames(metadata).contains(partitionName)) {
            throw new PartitionUnknownException(partitionName);
        }
        return partitionName;
    }

    public static PartitionName ofAssignmentsUnsafe(DocTableInfo table, List<Assignment<Object>> assignments) {
        if (!table.isPartitioned()) {
            throw new IllegalArgumentException("table '" + table.ident().fqn() + "' is not partitioned");
        }
        List<ColumnIdent> partitionedBy = table.partitionedBy();
        if (assignments.size() != partitionedBy.size()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The table \"%s\" is partitioned by %s columns but the PARTITION clause contains %s columns", table.ident().fqn(), partitionedBy.size(), assignments.size()));
        }
        String[] values = new String[partitionedBy.size()];
        for (Assignment<Object> assignment : assignments) {
            Object value = assignment.expression();
            ColumnIdent column = ColumnIdent.fromPath(assignment.columnName().toString());
            int idx = partitionedBy.indexOf(column);
            try {
                Reference reference = table.partitionedByColumns().get(idx);
                Object converted = reference.valueType().implicitCast(value);
                values[idx] = DataTypes.STRING.implicitCast(converted);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "\"%s\" is no known partition column", column.sqlFqn()));
            }
        }
        return new PartitionName(table.ident(), Arrays.asList(values));
    }

    public PartitionName(RelationName relationName, @NotNull List<String> values) {
        this.relationName = relationName;
        this.values = Objects.requireNonNull(values);
    }

    public PartitionName(RelationName relationName, @NotNull String partitionIdent) {
        this.relationName = relationName;
        this.ident = Objects.requireNonNull(partitionIdent);
    }

    public PartitionName(StreamInput in) throws IOException {
        this.relationName = new RelationName(in);
        int size = in.readVInt();
        if (size > 0) {
            this.values = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                this.values.add(in.readOptionalString());
            }
        }
    }

    public static String templateName(String indexName) {
        IndexParts indexParts = IndexName.decode(indexName);
        if (!indexParts.isPartitioned()) {
            throw new IllegalArgumentException("Cannot convert non-partitioned index name to templateName: " + indexName);
        }
        return PartitionName.templateName(indexParts.schema(), indexParts.table());
    }

    @Nullable
    public static List<String> decodeIdent(@Nullable String ident) {
        ArrayList<String> arrayList;
        block10: {
            if (ident == null) {
                return List.of();
            }
            byte[] inputBytes = BASE32.decode(ident.toUpperCase(Locale.ROOT));
            StreamInput in = StreamInput.wrap(inputBytes);
            try {
                int size = in.readVInt();
                ArrayList<String> values = new ArrayList<String>(size);
                for (int i = 0; i < size; ++i) {
                    values.add(PartitionName.readValueFrom(in));
                }
                arrayList = values;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid partition ident: %s", ident), e);
                }
            }
            in.close();
        }
        return arrayList;
    }

    private static String readValueFrom(StreamInput in) throws IOException {
        int length = in.readVInt() - 1;
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        in.readBytes(bytes, 0, length);
        char[] chars = new char[length];
        int len = UnicodeUtil.UTF8toUTF16((byte[])bytes, (int)0, (int)length, (char[])chars);
        return new String(chars, 0, len);
    }

    private static void writeValueTo(BytesStreamOutput out, @Nullable String value) throws IOException {
        if (value == null) {
            out.writeVInt(0);
        } else {
            byte[] v = value.getBytes(StandardCharsets.UTF_8);
            out.writeVInt(v.length + 1);
            out.writeBytes(v, 0, v.length);
        }
    }

    @Nullable
    public static String encodeIdent(Collection<? extends String> values) {
        if (values.size() == 0) {
            return null;
        }
        BytesStreamOutput streamOutput = new BytesStreamOutput(PartitionName.estimateSize(values));
        try {
            streamOutput.writeVInt(values.size());
            for (String string : values) {
                PartitionName.writeValueTo(streamOutput, string);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = BytesReference.toBytes(streamOutput.bytes());
        String string = BASE32.encodeAsString(bytes).toLowerCase(Locale.ROOT);
        int idx = string.indexOf(61);
        if (idx > -1) {
            return string.substring(0, idx);
        }
        return string;
    }

    private static int estimateSize(Iterable<? extends String> values) {
        int expectedEncodedSize = 0;
        for (String string : values) {
            expectedEncodedSize += 5 + (string != null ? string.length() : 0);
        }
        return expectedEncodedSize;
    }

    public String asIndexName() {
        if (this.indexName == null) {
            this.indexName = IndexName.encode(this.relationName.schema(), this.relationName.name(), this.ident());
        }
        return this.indexName;
    }

    @Nullable
    public String ident() {
        if (this.ident == null) {
            this.ident = PartitionName.encodeIdent(this.values);
        }
        return this.ident;
    }

    public List<String> values() {
        if (this.values == null) {
            if (this.ident == null) {
                return List.of();
            }
            this.values = PartitionName.decodeIdent(this.ident);
        }
        return this.values;
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public String toString() {
        return this.asIndexName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionName that = (PartitionName)o;
        return this.asIndexName().equals(that.asIndexName());
    }

    public int hashCode() {
        return this.asIndexName().hashCode();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.relationName.writeTo(out);
        if (this.values == null || this.values.isEmpty()) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.values.size());
            for (String value : this.values) {
                out.writeOptionalString(value);
            }
        }
    }

    public static PartitionName fromIndexOrTemplate(String indexOrTemplate) {
        assert (indexOrTemplate != null) : "indexOrTemplate must not be null";
        IndexParts indexParts = IndexName.decode(indexOrTemplate);
        if (!indexParts.isPartitioned()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Trying to create partition name from the name of a non-partitioned table %s", indexOrTemplate));
        }
        return new PartitionName(new RelationName(indexParts.schema(), indexParts.table()), indexParts.partitionIdent());
    }

    public static String templateName(String schemaName, String tableName) {
        return IndexName.encode(schemaName, tableName, "");
    }

    public static String templatePrefix(String schemaName, String tableName) {
        return PartitionName.templateName(schemaName, tableName) + "*";
    }
}

