/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.FunctionToQuery;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Roles;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public abstract class Scalar<ReturnType, InputType>
implements FunctionImplementation,
FunctionToQuery {
    public static final Set<Feature> DETERMINISTIC_ONLY = EnumSet.of(Feature.DETERMINISTIC);
    public static final Set<Feature> DETERMINISTIC_AND_COMPARISON_REPLACEMENT = EnumSet.of(Feature.DETERMINISTIC, Feature.COMPARISON_REPLACEMENT);
    protected final Signature signature;
    protected final BoundSignature boundSignature;

    protected Scalar(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    public abstract ReturnType evaluate(TransactionContext var1, NodeContext var2, Input<InputType> ... var3);

    public Scalar<ReturnType, InputType> compile(List<Symbol> arguments, String currentUser, Roles roles) {
        return this;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        try {
            return Scalar.evaluateIfLiterals(this, txnCtx, nodeCtx, symbol);
        }
        catch (Throwable t) {
            return symbol;
        }
    }

    protected static boolean anyNonLiterals(Collection<? extends Symbol> arguments) {
        for (Symbol symbol : arguments) {
            if (symbol.symbolType().isValueSymbol()) continue;
            return true;
        }
        return false;
    }

    protected static <ReturnType, InputType> Symbol evaluateIfLiterals(Scalar<ReturnType, InputType> scalar, TransactionContext txnCtx, NodeContext nodeCtx, Function function) {
        List<Symbol> arguments = function.arguments();
        for (Symbol argument : arguments) {
            if (argument instanceof Input) continue;
            return function;
        }
        Input[] inputs = new Input[arguments.size()];
        int idx = 0;
        for (Symbol arg : arguments) {
            inputs[idx] = (Input)arg;
            ++idx;
        }
        ReturnType result = scalar.evaluate(txnCtx, nodeCtx, inputs);
        DataType<?> returnType = function.valueType();
        if (returnType == DataTypes.UNDEFINED) {
            returnType = DataTypes.guessType(result);
        }
        return Literal.ofUnchecked(returnType, result);
    }

    public static enum Feature {
        DETERMINISTIC,
        COMPARISON_REPLACEMENT,
        LAZY_ATTRIBUTES,
        STRICTNULL,
        NOTNULL;

    }
}

