/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.blob;

import io.crate.blob.v2.BlobIndex;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.metadata.RelationName;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.blob.BlobTableInfoFactory;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;

public class BlobSchemaInfo
implements SchemaInfo {
    public static final String NAME = "blob";
    private final ClusterService clusterService;
    private final BlobTableInfoFactory blobTableInfoFactory;
    private final ConcurrentHashMap<String, BlobTableInfo> tableByName = new ConcurrentHashMap();

    public BlobSchemaInfo(ClusterService clusterService, BlobTableInfoFactory blobTableInfoFactory) {
        this.clusterService = clusterService;
        this.blobTableInfoFactory = blobTableInfoFactory;
    }

    @Override
    public TableInfo getTableInfo(String name) {
        try {
            return this.tableByName.computeIfAbsent(name, n -> this.blobTableInfoFactory.create(new RelationName(NAME, (String)n), this.clusterService.state().metadata()));
        }
        catch (Exception e) {
            if (e instanceof ResourceUnknownException) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void update(ClusterChangedEvent event) {
        if (event.metadataChanged()) {
            this.tableByName.clear();
        }
    }

    @Override
    public Iterable<TableInfo> getTables() {
        return Stream.of(this.clusterService.state().metadata().getConcreteAllOpenIndices()).filter(BlobIndex::isBlobIndex).map(BlobIndex::stripPrefix).map(this::getTableInfo)::iterator;
    }

    @Override
    public Iterable<ViewInfo> getViews() {
        return Collections.emptyList();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public BlobTableInfo create(RelationName relationName, Metadata metadata) {
        return this.blobTableInfoFactory.create(relationName, metadata);
    }
}

