/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.common.collections.Lists;
import io.crate.execution.ddl.index.SwapAndDropIndexRequest;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;

public class SwapAndDropIndexExecutor
extends DDLClusterStateTaskExecutor<SwapAndDropIndexRequest> {
    private final AllocationService allocationService;

    public SwapAndDropIndexExecutor(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    public ClusterState execute(ClusterState currentState, SwapAndDropIndexRequest request) throws Exception {
        Metadata metadata = currentState.metadata();
        String resizedIndexName = request.source();
        String originalIndexName = request.target();
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        Metadata.Builder mdBuilder = Metadata.builder(metadata);
        RoutingTable.Builder routingBuilder = RoutingTable.builder(currentState.routingTable());
        IndexMetadata resizedIndex = metadata.index(resizedIndexName);
        if (resizedIndex == null) {
            throw new IllegalArgumentException("Source index must exist: " + resizedIndexName);
        }
        IndexMetadata originalIndex = metadata.index(originalIndexName);
        if (originalIndex == null) {
            throw new IllegalArgumentException("Target index must exist: " + originalIndexName);
        }
        IndexRoutingTable index = currentState.routingTable().index(resizedIndex.getIndex());
        if (!index.allPrimaryShardsActive()) {
            throw new UnsupportedOperationException("Cannot swap and drop index if source '" + resizedIndexName + "' has unallocated primaries");
        }
        mdBuilder.remove(resizedIndexName);
        mdBuilder.remove(originalIndexName);
        routingBuilder.remove(resizedIndexName);
        routingBuilder.remove(originalIndexName);
        blocksBuilder.removeIndexBlocks(resizedIndexName);
        blocksBuilder.removeIndexBlocks(originalIndexName);
        IndexMetadata newIndexMetadata = IndexMetadata.builder(resizedIndex).index(originalIndexName).build();
        mdBuilder.put(newIndexMetadata, true);
        routingBuilder.addAsFromCloseToOpen(newIndexMetadata);
        blocksBuilder.addBlocks(newIndexMetadata);
        RelationName relationName = RelationName.fromIndexName(originalIndexName);
        Object relation = metadata.getRelation(relationName);
        if (relation instanceof RelationMetadata.Table) {
            RelationMetadata.Table table = (RelationMetadata.Table)relation;
            String originalUUID = originalIndex.getIndexUUID();
            List newUUIDs = Lists.map(table.indexUUIDs(), uuid -> uuid.equals(originalUUID) ? newIndexMetadata.getIndexUUID() : uuid);
            mdBuilder.setTable(table.name(), table.columns(), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), newUUIDs, table.tableVersion() + 1L);
        }
        return this.allocationService.reroute(ClusterState.builder(currentState).metadata(mdBuilder).routingTable(routingBuilder.build()).blocks(blocksBuilder).build(), "swap and drop index");
    }
}

