/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.SearchPath;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.VisibleForTesting;

public class SessionSettings
implements Writeable {
    protected String userName;
    protected SearchPath searchPath;
    protected boolean hashJoinsEnabled;
    protected boolean errorOnUnknownObjectKey;
    protected int memoryLimit;
    protected boolean insertSelectFailFast;

    @VisibleForTesting
    public SessionSettings(String userName, SearchPath searchPath) {
        this(userName, searchPath, true, true, 0, false);
    }

    public SessionSettings(String userName, SearchPath searchPath, boolean hashJoinsEnabled, boolean errorOnUnknownObjectKey, int memoryLimit, boolean insertSelectFailFast) {
        this.userName = userName;
        this.searchPath = searchPath;
        this.hashJoinsEnabled = hashJoinsEnabled;
        this.errorOnUnknownObjectKey = errorOnUnknownObjectKey;
        this.memoryLimit = memoryLimit;
        this.insertSelectFailFast = insertSelectFailFast;
    }

    public SessionSettings(StreamInput in) throws IOException {
        this.userName = in.readString();
        this.searchPath = SearchPath.createSearchPathFrom(in);
        this.hashJoinsEnabled = in.readBoolean();
        Version version = in.getVersion();
        this.errorOnUnknownObjectKey = version.onOrAfter(Version.V_4_7_0) ? in.readBoolean() : true;
        this.memoryLimit = version.onOrAfter(Version.V_5_5_0) ? in.readVInt() : 0;
        this.insertSelectFailFast = version.onOrAfter(Version.V_6_0_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.userName);
        this.searchPath.writeTo(out);
        out.writeBoolean(this.hashJoinsEnabled);
        Version version = out.getVersion();
        if (version.onOrAfter(Version.V_4_7_0)) {
            out.writeBoolean(this.errorOnUnknownObjectKey);
        }
        if (version.onOrAfter(Version.V_5_5_0)) {
            out.writeVInt(this.memoryLimit);
        }
        if (version.onOrAfter(Version.V_6_0_0)) {
            out.writeBoolean(this.insertSelectFailFast);
        }
    }

    public String userName() {
        return this.userName;
    }

    public String currentSchema() {
        return this.searchPath.currentSchema();
    }

    public SearchPath searchPath() {
        return this.searchPath;
    }

    public boolean hashJoinsEnabled() {
        return this.hashJoinsEnabled;
    }

    public boolean errorOnUnknownObjectKey() {
        return this.errorOnUnknownObjectKey;
    }

    public String applicationName() {
        return null;
    }

    public String dateStyle() {
        return null;
    }

    public TimeValue statementTimeout() {
        return TimeValue.ZERO;
    }

    public int memoryLimitInBytes() {
        return this.memoryLimit;
    }

    public void memoryLimit(int memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public boolean insertSelectFailFast() {
        return this.insertSelectFailFast;
    }

    public void insertSelectFailFast(boolean insertSelectFailFast) {
        this.insertSelectFailFast = insertSelectFailFast;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionSettings that = (SessionSettings)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.searchPath, that.searchPath) && Objects.equals(this.hashJoinsEnabled, that.hashJoinsEnabled) && Objects.equals(this.memoryLimit, that.memoryLimit) && Objects.equals(this.insertSelectFailFast, that.insertSelectFailFast);
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.searchPath, this.hashJoinsEnabled, this.memoryLimit, this.insertSelectFailFast);
    }
}

