/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.metadata.sys.MetricsView;
import io.crate.planner.operators.StatementClassifier;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;

public class ClassifiedMetrics
implements Iterable<MetricsView> {
    private static final long HIGHEST_TRACKABLE_VALUE = TimeUnit.MINUTES.toMillis(10L);
    private static final int NUMBER_OF_SIGNIFICANT_VALUE_DIGITS = 3;
    private final ConcurrentHashMap<StatementClassifier.Classification, Metrics> metrics = new ConcurrentHashMap();

    public void recordValue(StatementClassifier.Classification classification, long duration) {
        this.getOrCreate(classification).recordValue(duration);
    }

    public void recordFailedExecution(StatementClassifier.Classification classification, long duration) {
        this.getOrCreate(classification).recordFailedExecution(duration);
    }

    private Metrics getOrCreate(StatementClassifier.Classification classification) {
        Metrics histogram = this.metrics.get(classification);
        if (histogram == null) {
            histogram = new Metrics(classification);
            this.metrics.put(classification, histogram);
        }
        return histogram;
    }

    public void reset() {
        this.metrics.clear();
    }

    @Override
    public Iterator<MetricsView> iterator() {
        return this.metrics.values().stream().map(Metrics::createMetricsView).iterator();
    }

    public static class Metrics {
        private final StatementClassifier.Classification classification;
        private final LongAdder sumOfDurations = new LongAdder();
        private final LongAdder failedCount = new LongAdder();
        private final Recorder recorder;
        private final Histogram totalHistogram = new Histogram(HIGHEST_TRACKABLE_VALUE, 3);

        public Metrics(StatementClassifier.Classification classification) {
            this.classification = classification;
            this.recorder = new Recorder(HIGHEST_TRACKABLE_VALUE, 3);
        }

        public void recordValue(long duration) {
            this.recorder.recordValue(Math.min(Math.max(0L, duration), HIGHEST_TRACKABLE_VALUE));
            this.sumOfDurations.add(Math.max(0L, duration));
        }

        public void recordFailedExecution(long duration) {
            this.recordValue(duration);
            this.failedCount.increment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetricsView createMetricsView() {
            Histogram histogram;
            Histogram histogram2 = this.totalHistogram;
            synchronized (histogram2) {
                Histogram intervalHistogram = this.recorder.getIntervalHistogram();
                this.totalHistogram.add((AbstractHistogram)intervalHistogram);
                histogram = this.totalHistogram.copy();
            }
            return new MetricsView(histogram, this.sumOfDurations.longValue(), this.failedCount.longValue(), this.classification);
        }
    }
}

