/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.jetbrains.annotations.Nullable;

class TableHealth {
    private final String tableName;
    private final String tableSchema;
    @Nullable
    private final String partitionIdent;
    private final Health health;
    private final long missingShards;
    private final long underreplicatedShards;
    private final String fqn;

    public static Iterable<TableHealth> compute(ClusterState clusterState) {
        ClusterStateHealth clusterHealth = new ClusterStateHealth(clusterState);
        return StreamSupport.stream(clusterHealth.spliterator(), false).filter(i -> !IndexName.isDangling(i.getIndex())).map(TableHealth::map)::iterator;
    }

    private static TableHealth map(ClusterIndexHealth indexHealth) {
        IndexParts indexParts = IndexName.decode(indexHealth.getIndex());
        String partitionIdent = null;
        if (indexParts.isPartitioned()) {
            partitionIdent = indexParts.partitionIdent();
        }
        int missingPrimaryShards = Math.max(0, indexHealth.getNumberOfShards() - indexHealth.getActivePrimaryShards());
        int underreplicatedShards = Math.max(0, indexHealth.getUnassignedShards() + indexHealth.getInitializingShards() - missingPrimaryShards);
        return new TableHealth(indexParts.table(), indexParts.schema(), partitionIdent, Health.valueOf(indexHealth.getStatus().name()), missingPrimaryShards, underreplicatedShards);
    }

    TableHealth(String tableName, String tableSchema, @Nullable String partitionIdent, Health health, long missingShards, long underreplicatedShards) {
        this.tableName = tableName;
        this.tableSchema = tableSchema;
        this.partitionIdent = partitionIdent;
        this.health = health;
        this.missingShards = missingShards;
        this.underreplicatedShards = underreplicatedShards;
        this.fqn = IndexName.encode(tableSchema, tableName, null);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    @Nullable
    public String getPartitionIdent() {
        return this.partitionIdent;
    }

    public Health health() {
        return this.health;
    }

    public String getHealth() {
        return this.health.toString();
    }

    public short getSeverity() {
        return this.health.severity();
    }

    public long getMissingShards() {
        return this.missingShards;
    }

    public long getUnderreplicatedShards() {
        return this.underreplicatedShards;
    }

    public String fqn() {
        return this.fqn;
    }

    public String toString() {
        return "TableHealth{name='" + this.tableName + "', schema='" + this.tableSchema + "', partitionIdent='" + this.partitionIdent + "', health=" + String.valueOf((Object)this.health) + ", missingShards=" + this.missingShards + ", underreplicatedShards=" + this.underreplicatedShards + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableHealth that = (TableHealth)o;
        if (this.missingShards != that.missingShards) {
            return false;
        }
        if (this.underreplicatedShards != that.underreplicatedShards) {
            return false;
        }
        if (!this.tableName.equals(that.tableName)) {
            return false;
        }
        if (!this.tableSchema.equals(that.tableSchema)) {
            return false;
        }
        if (this.partitionIdent != null ? !this.partitionIdent.equals(that.partitionIdent) : that.partitionIdent != null) {
            return false;
        }
        return this.health == that.health;
    }

    public int hashCode() {
        int result = this.tableName.hashCode();
        result = 31 * result + this.tableSchema.hashCode();
        result = 31 * result + (this.partitionIdent != null ? this.partitionIdent.hashCode() : 0);
        result = 31 * result + this.health.hashCode();
        result = 31 * result + (int)(this.missingShards ^ this.missingShards >>> 32);
        result = 31 * result + (int)(this.underreplicatedShards ^ this.underreplicatedShards >>> 32);
        return result;
    }

    static enum Health {
        GREEN,
        YELLOW,
        RED;


        public short severity() {
            return (short)(this.ordinal() + 1);
        }
    }
}

