/*
 * Decompiled with CFR 0.152.
 */
package io.crate.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.Netty4Utils;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class NettyBootstrap
extends AbstractLifecycleComponent {
    public static final String WORKER_THREAD_PREFIX = "netty-worker";
    private static final Logger LOGGER = LogManager.getLogger(NettyBootstrap.class);
    private final Settings settings;
    private EventLoopGroup worker;

    public NettyBootstrap(Settings settings) {
        this.settings = settings;
        Netty4Utils.setAvailableProcessors(EsExecutors.PROCESSORS_SETTING.get(settings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean workerIsShutdown() {
        NettyBootstrap nettyBootstrap = this;
        synchronized (nettyBootstrap) {
            return this.worker == null || this.worker.isShutdown();
        }
    }

    public synchronized EventLoopGroup getSharedEventLoopGroup() {
        if (this.worker == null) {
            throw new IllegalStateException("NettyBootstrap wasn't started yet or is already closed");
        }
        return this.worker;
    }

    public static EventLoopGroup newEventLoopGroup(Settings settings) {
        ThreadFactory workerThreads = EsExecutors.daemonThreadFactory(settings, WORKER_THREAD_PREFIX);
        int workerCount = Netty4Transport.WORKER_COUNT.get(settings);
        IoHandlerFactory ioHandlerFactory = Epoll.isAvailable() ? EpollIoHandler.newFactory() : NioIoHandler.newFactory();
        return new MultiThreadIoEventLoopGroup(workerCount, workerThreads, ioHandlerFactory);
    }

    public static Class<? extends Channel> clientChannel() {
        if (Epoll.isAvailable()) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> serverChannel() {
        if (Epoll.isAvailable()) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static ServerBootstrap newServerBootstrap(Settings settings, EventLoopGroup eventLoopGroup) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.channel(NettyBootstrap.serverChannel());
        Boolean reuseAddress = TransportSettings.TCP_REUSE_ADDRESS.get(settings);
        return ((ServerBootstrap)serverBootstrap.group(eventLoopGroup).option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress)).childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress).childOption(ChannelOption.TCP_NODELAY, (Object)TransportSettings.TCP_NO_DELAY.get(settings)).childOption(ChannelOption.SO_KEEPALIVE, (Object)TransportSettings.TCP_KEEP_ALIVE.get(settings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        NettyBootstrap nettyBootstrap = this;
        synchronized (nettyBootstrap) {
            this.worker = NettyBootstrap.newEventLoopGroup(this.settings);
        }
    }

    @Override
    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        NettyBootstrap nettyBootstrap = this;
        synchronized (nettyBootstrap) {
            Future shutdownGracefully = this.worker.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
            shutdownGracefully.awaitUninterruptibly();
            if (!shutdownGracefully.isSuccess()) {
                LOGGER.warn("Error closing netty event loop group", shutdownGracefully.cause());
            }
            this.worker = null;
        }
    }
}

